/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiPort;
import org.herac.tuxguitar.player.base.MidiPortEmpty;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.impl.sequencer.MidiEvent;
import org.herac.tuxguitar.player.impl.sequencer.MidiEventDispacher;
import org.herac.tuxguitar.player.impl.sequencer.MidiEventPlayer;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.player.impl.sequencer.MidiTickPlayer;
import org.herac.tuxguitar.player.impl.sequencer.MidiTrackController;
import org.herac.tuxguitar.util.TGLock;

public class MidiSequencerImpl
implements MidiSequencer {
    private static final TGLock lock = new TGLock();
    private boolean reset;
    private boolean running = false;
    private MidiPort midiPort;
    private MidiTickPlayer midiTickPlayer = new MidiTickPlayer();
    private MidiEventPlayer midiEventPlayer = new MidiEventPlayer(this);
    private MidiEventDispacher midiEventDispacher = new MidiEventDispacher(this);
    private MidiTrackController midiTrackController = new MidiTrackController(this);

    public MidiTrackController getMidiTrackController() {
        return this.midiTrackController;
    }

    public void setTempo(int n) {
        this.midiTickPlayer.setTempo(n);
    }

    public long getTickPosition() {
        return this.midiTickPlayer.getTick();
    }

    public long getTickLength() {
        return this.midiTickPlayer.getTickLength();
    }

    public void setTickPosition(long l) {
        this.reset = true;
        this.midiTickPlayer.setTick(l);
    }

    public void sendEvent(MidiEvent midiEvent) throws MidiPlayerException {
        if (!this.reset) {
            this.midiEventDispacher.dispatch(midiEvent);
        }
    }

    public void addEvent(MidiEvent midiEvent) {
        this.midiEventPlayer.addEvent(midiEvent);
        this.midiTickPlayer.notifyTick(midiEvent.getTick());
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean bl) throws MidiPlayerException {
        this.running = bl;
        this.setTempo(120);
        this.setTickPosition(0L);
        if (this.running) {
            new MidiTimer(this).start();
        } else {
            this.midiEventPlayer.clearEvents();
            this.midiTickPlayer.clearTick();
            this.getMidiPort().out().sendAllNotesOff();
            this.getMidiPort().out().sendSystemReset();
        }
    }

    public synchronized void stop() throws MidiPlayerException {
        this.setRunning(false);
    }

    public synchronized void start() throws MidiPlayerException {
        this.setRunning(true);
    }

    protected synchronized boolean process() throws MidiPlayerException {
        boolean bl = this.isRunning();
        if (bl && !lock.isLocked()) {
            lock.lock();
            if (this.reset) {
                this.reset = false;
                this.getMidiPort().out().sendAllNotesOff();
                for (int i = 0; i < 16; ++i) {
                    this.getMidiPort().out().sendPitchBend(i, 64);
                }
                this.midiEventPlayer.reset();
            }
            this.midiEventPlayer.process();
            this.midiTickPlayer.process();
            if (this.getTickPosition() > this.getTickLength()) {
                this.stop();
            }
            lock.unlock();
        }
        return bl;
    }

    public MidiPort getMidiPort() {
        if (this.midiPort == null) {
            this.midiPort = new MidiPortEmpty();
        }
        return this.midiPort;
    }

    public void setMidiPort(MidiPort midiPort) {
        this.midiPort = midiPort;
    }

    public void open() {
    }

    public void close() throws MidiPlayerException {
        if (this.isRunning()) {
            this.stop();
        }
    }

    public MidiSequenceHandler createSequence(int n) {
        return new MidiSequenceHandlerImpl(this, n);
    }

    public void setSolo(int n, boolean bl) throws MidiPlayerException {
        this.getMidiTrackController().setSolo(n, bl);
    }

    public void setMute(int n, boolean bl) throws MidiPlayerException {
        this.getMidiTrackController().setMute(n, bl);
    }

    public String getKey() {
        return "tuxguitar.sequencer";
    }

    public String getName() {
        return "TuxGuitar Sequencer";
    }

    private class MidiTimer
    extends Thread {
        private static final int TIMER_DELAY = 15;
        private MidiSequencerImpl sequencer;

        public MidiTimer(MidiSequencerImpl midiSequencerImpl2) {
            this.sequencer = midiSequencerImpl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MidiSequencerImpl midiSequencerImpl = this.sequencer;
                synchronized (midiSequencerImpl) {
                    while (this.sequencer.process()) {
                        this.sequencer.wait(15L);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

