/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.sequencer.MidiEvent;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequencerImpl;

public class MidiEventDispacher {
    private MidiSequencerImpl sequencer;

    public MidiEventDispacher(MidiSequencerImpl midiSequencerImpl) {
        this.sequencer = midiSequencerImpl;
    }

    public void dispatch(MidiEvent midiEvent) throws MidiPlayerException {
        if (midiEvent.getType() == 2) {
            this.sequencer.getMidiPort().out().sendNoteOn(midiEvent.getData()[0], midiEvent.getData()[1], midiEvent.getData()[2]);
        } else if (midiEvent.getType() == 3) {
            this.sequencer.getMidiPort().out().sendNoteOff(midiEvent.getData()[0], midiEvent.getData()[1], midiEvent.getData()[2]);
        } else if (midiEvent.getType() == 5) {
            this.sequencer.getMidiPort().out().sendControlChange(midiEvent.getData()[0], midiEvent.getData()[1], midiEvent.getData()[2]);
        } else if (midiEvent.getType() == 4) {
            this.sequencer.getMidiPort().out().sendProgramChange(midiEvent.getData()[0], midiEvent.getData()[1]);
        } else if (midiEvent.getType() == 6) {
            this.sequencer.getMidiPort().out().sendPitchBend(midiEvent.getData()[0], midiEvent.getData()[1]);
        } else if (midiEvent.getType() == 1 && midiEvent.getData()[0] == 81) {
            int n = midiEvent.getData()[1] & 0xFF | (midiEvent.getData()[2] & 0xFF) << 8 | (midiEvent.getData()[3] & 0xFF) << 16;
            this.sequencer.setTempo((int)(60000.0 / ((double)n / 1000.0)));
        }
    }
}

