/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;

public class MidiRepeatController {
    private TGSong song;
    private int count;
    private int index;
    private int lastIndex;
    private boolean shouldPlay;
    private boolean repeatOpen;
    private long repeatStart;
    private long repeatEnd;
    private long repeatMove;
    private int repeatStartIndex;
    private int repeatNumber;
    private int repeatAlternative;

    public MidiRepeatController(TGSong tGSong) {
        this.song = tGSong;
        this.count = tGSong.countMeasureHeaders();
        this.index = 0;
        this.lastIndex = -1;
        this.shouldPlay = true;
        this.repeatOpen = true;
        this.repeatAlternative = 0;
        this.repeatStart = 1000L;
        this.repeatEnd = 0L;
        this.repeatMove = 0L;
        this.repeatStartIndex = 0;
        this.repeatNumber = 0;
    }

    public void process() {
        TGMeasureHeader tGMeasureHeader = this.song.getMeasureHeader(this.index);
        this.shouldPlay = true;
        if (tGMeasureHeader.isRepeatOpen()) {
            this.repeatStartIndex = this.index;
            this.repeatStart = tGMeasureHeader.getStart();
            this.repeatOpen = true;
            if (this.index > this.lastIndex) {
                this.repeatNumber = 0;
                this.repeatAlternative = 0;
            }
        } else {
            if (this.repeatAlternative == 0) {
                this.repeatAlternative = tGMeasureHeader.getRepeatAlternative();
            }
            if (this.repeatOpen && this.repeatAlternative > 0 && (this.repeatAlternative & 1 << this.repeatNumber) == 0) {
                this.repeatMove -= tGMeasureHeader.getLength();
                if (tGMeasureHeader.getRepeatClose() > 0) {
                    this.repeatAlternative = 0;
                }
                this.shouldPlay = false;
                ++this.index;
                return;
            }
        }
        this.lastIndex = Math.max(this.lastIndex, this.index);
        if (this.repeatOpen && tGMeasureHeader.getRepeatClose() > 0) {
            if (this.repeatNumber < tGMeasureHeader.getRepeatClose() || this.repeatAlternative > 0) {
                this.repeatEnd = tGMeasureHeader.getStart() + tGMeasureHeader.getLength();
                this.repeatMove += this.repeatEnd - this.repeatStart;
                this.index = this.repeatStartIndex - 1;
                ++this.repeatNumber;
            } else {
                this.repeatStart = 0L;
                this.repeatNumber = 0;
                this.repeatEnd = 0L;
                this.repeatOpen = false;
            }
            this.repeatAlternative = 0;
        }
        ++this.index;
    }

    public boolean finished() {
        return this.index >= this.count;
    }

    public boolean shouldPlay() {
        return this.shouldPlay;
    }

    public int getIndex() {
        return this.index;
    }

    public long getRepeatMove() {
        return this.repeatMove;
    }
}

