/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TGTrack;

public class UndoableRemoveTrack
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private TGTrack undoableTrack;

    private UndoableRemoveTrack() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().removeTrack(UndoableRemoveTrack.cloneTrack(this.undoableTrack));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        TuxGuitar.instance().getSongManager().addTrack(UndoableRemoveTrack.cloneTrack(this.undoableTrack));
        TuxGuitar.instance().fireUpdate();
        TuxGuitar.instance().getMixer().update();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableRemoveTrack startUndo() {
        UndoableRemoveTrack undoableRemoveTrack = new UndoableRemoveTrack();
        Caret caret = UndoableRemoveTrack.getCaret();
        undoableRemoveTrack.doAction = 1;
        undoableRemoveTrack.undoCaret = new UndoableCaretHelper();
        undoableRemoveTrack.undoableTrack = UndoableRemoveTrack.cloneTrack(caret.getTrack());
        return undoableRemoveTrack;
    }

    public UndoableRemoveTrack endUndo() {
        this.redoCaret = new UndoableCaretHelper();
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private static TGTrack cloneTrack(TGTrack tGTrack) {
        return tGTrack.clone(TuxGuitar.instance().getSongManager().getFactory(), TuxGuitar.instance().getSongManager().getSong());
    }
}

