/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins.base;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.base.TGPluginBase;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;

public abstract class TGMidiSequencerProviderPlugin
extends TGPluginBase {
    private boolean loaded;
    private MidiSequencerProvider provider;

    protected abstract MidiSequencerProvider getProvider();

    public void init(TuxGuitar tuxGuitar) {
        this.provider = this.getProvider();
        this.loaded = false;
    }

    public void close() throws TGPluginException {
        try {
            this.provider.closeAll();
        }
        catch (MidiPlayerException midiPlayerException) {
            throw new TGPluginException(midiPlayerException.getMessage(), midiPlayerException);
        }
    }

    protected void addPluin() throws TGPluginException {
        if (!this.loaded) {
            try {
                TuxGuitar.instance().getPlayer().addSequencerProvider(this.provider);
                this.loaded = true;
            }
            catch (MidiPlayerException midiPlayerException) {
                throw new TGPluginException(midiPlayerException.getMessage(), midiPlayerException);
            }
        }
    }

    protected void removePluin() throws TGPluginException {
        if (this.loaded) {
            try {
                TuxGuitar.instance().getPlayer().removeSequencerProvider(this.provider);
                this.loaded = false;
            }
            catch (MidiPlayerException midiPlayerException) {
                throw new TGPluginException(midiPlayerException.getMessage(), midiPlayerException);
            }
        }
    }

    public void setEnabled(boolean bl) throws TGPluginException {
        if (bl) {
            this.addPluin();
        } else {
            this.removePluin();
        }
    }
}

