/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.plugins.TGPlugin;
import org.herac.tuxguitar.gui.system.plugins.TGPluginException;
import org.herac.tuxguitar.gui.system.plugins.TGPluginProperties;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.util.TGClassLoader;
import org.herac.tuxguitar.util.TGServiceReader;

public class TGPluginManager {
    private List plugins = new ArrayList();

    public TGPluginManager() {
        this.initPLugins();
    }

    public List getPlugins() {
        return this.plugins;
    }

    public void initPLugins() {
        try {
            Iterator iterator = TGServiceReader.lookupProviders(TGPlugin.class, TGClassLoader.instance().getClassLoader());
            while (iterator.hasNext()) {
                try {
                    TGPlugin tGPlugin = (TGPlugin)iterator.next();
                    tGPlugin.init(TuxGuitar.instance());
                    this.plugins.add(tGPlugin);
                }
                catch (TGPluginException tGPluginException) {
                    MessageDialog.errorMessage(tGPluginException);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(new TGPluginException("An error ocurred when trying to init plugin", throwable));
                }
            }
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(new TGPluginException("An error ocurred when trying to init plugin", throwable));
        }
    }

    public void closePLugins() {
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            try {
                ((TGPlugin)iterator.next()).close();
            }
            catch (TGPluginException tGPluginException) {
                MessageDialog.errorMessage(tGPluginException);
            }
            catch (Throwable throwable) {
                MessageDialog.errorMessage(new TGPluginException("An error ocurred when trying to close plugin", throwable));
            }
        }
    }

    public void openPlugins() {
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            try {
                TGPlugin tGPlugin = (TGPlugin)iterator.next();
                tGPlugin.setEnabled(this.isEnabled(tGPlugin));
            }
            catch (TGPluginException tGPluginException) {
                MessageDialog.errorMessage(tGPluginException);
            }
            catch (Throwable throwable) {
                MessageDialog.errorMessage(new TGPluginException("An error ocurred when trying to set plugin status", throwable));
            }
        }
    }

    public void setEnabled(TGPlugin tGPlugin, boolean bl) {
        try {
            TGPluginProperties.instance().setProperty(this.getEnabledProperty(tGPlugin), bl);
            TGPluginProperties.instance().save();
            tGPlugin.setEnabled(bl);
        }
        catch (TGPluginException tGPluginException) {
            MessageDialog.errorMessage(tGPluginException);
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(new TGPluginException("An error ocurred when trying to set plugin status", throwable));
        }
    }

    public boolean isEnabled(TGPlugin tGPlugin) {
        try {
            return TGPluginProperties.instance().getBooleanConfigValue(this.getEnabledProperty(tGPlugin), true);
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(new TGPluginException("An error ocurred when trying to get plugin status", throwable));
            return false;
        }
    }

    public String getEnabledProperty(TGPlugin tGPlugin) {
        return tGPlugin.getClass().getName() + ".enabled";
    }
}

