/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.mixer.TGMixerTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackChannel;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGMixerTrackChannel {
    private TGMixerTrack mixer;
    protected Combo normalChannel;
    protected Combo effectChannel;
    protected ChannelList normalChannels;
    protected ChannelList effectChannels;

    public TGMixerTrackChannel(TGMixerTrack tGMixerTrack) {
        this.mixer = tGMixerTrack;
    }

    protected TGTrack getTrack() {
        return this.mixer.getTrack();
    }

    protected TGChannel getChannel() {
        return this.mixer.getTrack().getChannel();
    }

    public void init(Composite composite) {
        this.normalChannels = new ChannelList();
        this.normalChannel = new Combo(composite, 12);
        this.normalChannel.setLayoutData((Object)new GridData(768));
        this.effectChannels = new ChannelList();
        this.effectChannel = new Combo(composite, 12);
        this.effectChannel.setLayoutData((Object)new GridData(768));
        this.normalChannel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                UndoableTrackChannel undoableTrackChannel = UndoableTrackChannel.startUndo();
                TGChannel tGChannel = TGMixerTrackChannel.this.getTrack().getChannel();
                boolean[] blArray = TuxGuitar.instance().getSongManager().getUsedChannels();
                if (!blArray[n = TGMixerTrackChannel.this.normalChannels.getChannel(TGMixerTrackChannel.this.normalChannel.getSelectionIndex())]) {
                    tGChannel.setChannel((short)n);
                    tGChannel.setEffectChannel(tGChannel.getChannel());
                } else {
                    TGChannel tGChannel2 = TuxGuitar.instance().getSongManager().getUsedChannel(n);
                    tGChannel.setChannel(tGChannel2.getChannel());
                    tGChannel.setEffectChannel(tGChannel2.getEffectChannel());
                    tGChannel.setVolume(tGChannel2.getVolume());
                    tGChannel.setBalance(tGChannel2.getBalance());
                    tGChannel.setChorus(tGChannel2.getChorus());
                    tGChannel.setInstrument(tGChannel2.getInstrument());
                    tGChannel.setPhaser(tGChannel2.getPhaser());
                    tGChannel.setReverb(tGChannel2.getReverb());
                    tGChannel.setTremolo(tGChannel2.getTremolo());
                    tGChannel.setSolo(tGChannel2.isSolo());
                    tGChannel.setMute(tGChannel2.isMute());
                }
                TGMixerTrackChannel.this.fireChannelChange(tGChannel);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackChannel.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                TuxGuitar.instance().updateCache(true);
            }
        });
        this.effectChannel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UndoableTrackChannel undoableTrackChannel = UndoableTrackChannel.startUndo();
                TGChannel tGChannel = TGMixerTrackChannel.this.getTrack().getChannel();
                int n = TGMixerTrackChannel.this.effectChannels.getChannel(TGMixerTrackChannel.this.effectChannel.getSelectionIndex());
                tGChannel.setEffectChannel((short)n);
                TGMixerTrackChannel.this.fireChannelChange(tGChannel);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackChannel.endUndo());
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                TuxGuitar.instance().updateCache(true);
            }
        });
        this.updateItems(true);
    }

    public void updateItems(boolean bl) {
        if (bl) {
            this.updateNormalChannel();
            this.updateEffectChannel();
        }
        this.normalChannel.setEnabled(!TuxGuitar.instance().getPlayer().isRunning());
        this.effectChannel.setEnabled(!TuxGuitar.instance().getPlayer().isRunning());
    }

    private void updateNormalChannel() {
        this.normalChannel.removeAll();
        this.normalChannels.clear();
        boolean[] blArray = TuxGuitar.instance().getSongManager().getUsedChannels();
        boolean[] blArray2 = TuxGuitar.instance().getSongManager().getUsedEffectChannels();
        if (this.getChannel().isPercussionChannel()) {
            this.normalChannel.add(Integer.toString(9));
            this.normalChannel.select(0);
            this.normalChannels.addChannel(0, 0);
        } else {
            int n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (TGChannel.isPercussionChannel(i) || blArray2[i] && (!blArray2[i] || !blArray[i]) && (this.getChannel().getChannel() != i || this.getChannel().getEffectChannel() != this.getChannel().getChannel())) continue;
                String string = new String();
                string = blArray[i] && (this.getChannel().getChannel() != i || TuxGuitar.instance().getSongManager().countTracksForChannel(i) > 1) ? i + " " + TuxGuitar.getProperty("mixer.channel.link") : i + " " + TuxGuitar.getProperty("mixer.channel.free");
                this.normalChannel.add(string);
                if (i == this.getChannel().getChannel()) {
                    this.normalChannel.select(n);
                }
                this.normalChannels.addChannel(n, i);
                ++n;
            }
        }
    }

    private void updateEffectChannel() {
        this.effectChannel.removeAll();
        this.effectChannels.clear();
        boolean[] blArray = TuxGuitar.instance().getSongManager().getUsedChannels();
        boolean[] blArray2 = TuxGuitar.instance().getSongManager().getUsedEffectChannels();
        if (this.getChannel().isPercussionChannel()) {
            this.effectChannel.add(Integer.toString(9));
            this.effectChannel.select(0);
            this.effectChannels.addChannel(0, 0);
        } else {
            int n = 0;
            for (int i = 0; i < blArray2.length; ++i) {
                if (TGChannel.isPercussionChannel(i) || blArray2[i] && this.getChannel().getEffectChannel() != i || blArray[i] && i != this.getChannel().getChannel()) continue;
                this.effectChannel.add(Integer.toString(i));
                if (i == this.getChannel().getEffectChannel()) {
                    this.effectChannel.select(n);
                }
                this.effectChannels.addChannel(n, i);
                ++n;
            }
        }
    }

    public void fireChannelChange(TGChannel tGChannel) {
        this.mixer.getMixer().fireChanges(tGChannel, 16);
    }

    private class ChannelIndex {
        private int index;
        private int channel;

        public ChannelIndex(int n, int n2) {
            this.index = n;
            this.channel = n2;
        }

        public int getChannel() {
            return this.channel;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private class ChannelList {
        private List channelIndexs = new ArrayList();

        public void addChannel(int n, int n2) {
            this.channelIndexs.add(new ChannelIndex(n, n2));
        }

        public int getChannel(int n) {
            Iterator iterator = this.channelIndexs.iterator();
            while (iterator.hasNext()) {
                ChannelIndex channelIndex = (ChannelIndex)iterator.next();
                if (n != channelIndex.getIndex()) continue;
                return channelIndex.getChannel();
            }
            return -1;
        }

        public void clear() {
            this.channelIndexs.clear();
        }
    }
}

