/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.TGChord;

public class NoteToolItems
extends ToolItems {
    public static final String NAME = "note.items";
    protected ToolBar toolBar;
    private ToolItem tiedNote;
    private ChordMenuItem chordItems;

    public NoteToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.tiedNote = new ToolItem(toolBar, 8);
        this.tiedNote.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.note.general.tied"));
        this.chordItems = new ChordMenuItem();
        this.chordItems.addItems();
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.tiedNote.setEnabled(!bl);
        this.chordItems.setEnabled(!bl);
        this.chordItems.update();
    }

    public void loadProperties() {
        this.tiedNote.setToolTipText(TuxGuitar.getProperty("note.tiednote"));
        this.chordItems.setToolTipText(TuxGuitar.getProperty("insert.chord"));
    }

    public void loadIcons() {
        this.tiedNote.setImage(TuxGuitar.instance().getIconManager().getNoteTied());
        this.chordItems.setImage(TuxGuitar.instance().getIconManager().getChord());
    }

    private class ChordMenuItem
    extends SelectionAdapter {
        private long lastEdit;
        private ToolItem item;
        private Menu subMenu;
        private MenuItem[] subMenuItems;

        public ChordMenuItem() {
            this.item = new ToolItem(NoteToolItems.this.toolBar, 4);
            this.item.addSelectionListener((SelectionListener)this);
            this.subMenu = new Menu((Control)this.item.getParent().getShell());
        }

        public void setToolTipText(String string) {
            this.item.setToolTipText(string);
        }

        public void setEnabled(boolean bl) {
            this.item.setEnabled(bl);
        }

        public void setImage(Image image) {
            this.item.setImage(image);
        }

        public void addItems() {
            this.disposeItems();
            this.subMenuItems = new MenuItem[TuxGuitar.instance().getCustomChordManager().countChords()];
            for (int i = 0; i < this.subMenuItems.length; ++i) {
                TGChord tGChord = TuxGuitar.instance().getCustomChordManager().getChord(i);
                this.subMenuItems[i] = new MenuItem(this.subMenu, 8);
                this.subMenuItems[i].setData((Object)tGChord);
                this.subMenuItems[i].setText(tGChord.getName());
                this.subMenuItems[i].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.insert.chord"));
            }
        }

        public void disposeItems() {
            if (this.subMenuItems != null) {
                for (int i = 0; i < this.subMenuItems.length; ++i) {
                    this.subMenuItems[i].dispose();
                }
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.detail == 4 && this.subMenuItems != null && this.subMenuItems.length > 0) {
                ToolItem toolItem = (ToolItem)selectionEvent.widget;
                Rectangle rectangle = toolItem.getBounds();
                Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
                this.subMenu.setLocation(point.x, point.y + rectangle.height);
                this.subMenu.setVisible(true);
            } else {
                TuxGuitar.instance().getAction("action.insert.chord").process((TypedEvent)selectionEvent);
            }
        }

        public void update() {
            if (this.lastEdit != TuxGuitar.instance().getCustomChordManager().getLastEdit()) {
                this.addItems();
                this.lastEdit = TuxGuitar.instance().getCustomChordManager().getLastEdit();
            }
        }
    }
}

