/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;

public class TransportMenuItem
implements MenuItems {
    private static final int STATUS_STOPPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private MenuItem transportMenuItem;
    private Menu menu;
    private MenuItem play;
    private MenuItem stop;
    private MenuItem mode;
    private MenuItem metronome;
    private int status;

    public TransportMenuItem(Shell shell, Menu menu, int n) {
        this.transportMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.play = new MenuItem(this.menu, 8);
        this.play.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().play((TypedEvent)selectionEvent);
            }
        });
        this.stop = new MenuItem(this.menu, 8);
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().stop((TypedEvent)selectionEvent);
            }
        });
        new MenuItem(this.menu, 2);
        this.metronome = new MenuItem(this.menu, 32);
        this.metronome.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.metronome"));
        this.mode = new MenuItem(this.menu, 8);
        this.mode.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.transport.mode"));
        this.transportMenuItem.setMenu(this.menu);
        this.status = 1;
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        this.metronome.setSelection(TuxGuitar.instance().getPlayer().isMetronomeEnabled());
        this.loadIcons(false);
    }

    public void loadProperties() {
        this.transportMenuItem.setText(TuxGuitar.getProperty("transport"));
        this.play.setText(TuxGuitar.getProperty("transport.start"));
        this.stop.setText(TuxGuitar.getProperty("transport.stop"));
        this.mode.setText(TuxGuitar.getProperty("transport.mode"));
        this.metronome.setText(TuxGuitar.getProperty("transport.metronome"));
    }

    public void loadIcons() {
        this.loadIcons(true);
        this.mode.setImage(TuxGuitar.instance().getIconManager().getTransportMode());
        this.metronome.setImage(TuxGuitar.instance().getIconManager().getTransportMetronome());
    }

    public void loadIcons(boolean bl) {
        int n = this.status;
        this.status = TuxGuitar.instance().getPlayer().isRunning() ? 3 : (TuxGuitar.instance().getPlayer().isPaused() ? 2 : 1);
        if (bl || n != this.status) {
            if (this.status == 3) {
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPause());
            } else if (this.status == 2) {
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop2());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay2());
            } else if (this.status == 1) {
                this.stop.setImage(TuxGuitar.instance().getIconManager().getTransportIconStop1());
                this.play.setImage(TuxGuitar.instance().getIconManager().getTransportIconPlay1());
            }
        }
    }
}

