/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.items.MenuItems;

public class TrackMenuItem
implements MenuItems {
    private MenuItem trackMenuItem;
    private Menu menu;
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addTrack;
    private MenuItem cloneTrack;
    private MenuItem removeTrack;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem lyrics;
    private MenuItem properties;

    public TrackMenuItem(Shell shell, Menu menu, int n) {
        this.trackMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.first = new MenuItem(this.menu, 8);
        this.first.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.go-first"));
        this.previous = new MenuItem(this.menu, 8);
        this.previous.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.go-previous"));
        this.next = new MenuItem(this.menu, 8);
        this.next.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.go-next"));
        this.last = new MenuItem(this.menu, 8);
        this.last.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.go-last"));
        new MenuItem(this.menu, 2);
        this.addTrack = new MenuItem(this.menu, 8);
        this.addTrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.add"));
        this.cloneTrack = new MenuItem(this.menu, 8);
        this.cloneTrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.clone"));
        this.removeTrack = new MenuItem(this.menu, 8);
        this.removeTrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.remove"));
        new MenuItem(this.menu, 2);
        this.moveUp = new MenuItem(this.menu, 8);
        this.moveUp.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.move-up"));
        this.moveDown = new MenuItem(this.menu, 8);
        this.moveDown.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.move-down"));
        new MenuItem(this.menu, 2);
        this.lyrics = new MenuItem(this.menu, 8);
        this.lyrics.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.lyrics"));
        this.properties = new MenuItem(this.menu, 8);
        this.properties.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.track.properties"));
        this.trackMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        this.trackMenuItem.setText(TuxGuitar.getProperty("track"));
        this.first.setText(TuxGuitar.getProperty("track.first"));
        this.last.setText(TuxGuitar.getProperty("track.last"));
        this.previous.setText(TuxGuitar.getProperty("track.previous"));
        this.next.setText(TuxGuitar.getProperty("track.next"));
        this.addTrack.setText(TuxGuitar.getProperty("track.add"));
        this.cloneTrack.setText(TuxGuitar.getProperty("track.clone"));
        this.removeTrack.setText(TuxGuitar.getProperty("track.remove"));
        this.moveUp.setText(TuxGuitar.getProperty("track.move-up"));
        this.moveDown.setText(TuxGuitar.getProperty("track.move-down"));
        this.lyrics.setText(TuxGuitar.getProperty("track.lyrics"));
        this.properties.setText(TuxGuitar.getProperty("track.properties"));
    }

    public void update() {
        TGTrackImpl tGTrackImpl = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getTrack();
        int n = tGTrackImpl.getSong().countTracks();
        boolean bl = tGTrackImpl.getNumber() == 1;
        boolean bl2 = tGTrackImpl.getNumber() == n;
        boolean bl3 = TuxGuitar.instance().getPlayer().isRunning();
        this.addTrack.setEnabled(!bl3);
        this.cloneTrack.setEnabled(!bl3);
        this.removeTrack.setEnabled(!bl3);
        this.moveUp.setEnabled(!bl3 && n > 1);
        this.moveDown.setEnabled(!bl3 && n > 1);
        this.first.setEnabled(!bl);
        this.previous.setEnabled(!bl);
        this.next.setEnabled(!bl2);
        this.last.setEnabled(!bl2);
        this.properties.setEnabled(!bl3);
    }

    public void loadIcons() {
    }
}

