/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.items.MenuItems;

public class LayoutMenuItem
implements MenuItems {
    private Menu menu;
    private Menu chordMenu;
    private MenuItem layoutMenuItem;
    private MenuItem showMixer;
    private MenuItem showTransport;
    private MenuItem showFretBoard;
    private MenuItem showPiano;
    private MenuItem showMatrix;
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;
    private MenuItem scoreEnabled;
    private MenuItem tablatureEnabled;
    private MenuItem compact;
    private MenuItem chordMenuItem;
    private MenuItem chordName;
    private MenuItem chordDiagram;

    public LayoutMenuItem(Shell shell, Menu menu, int n) {
        this.layoutMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.showMixer = new MenuItem(this.menu, 32);
        this.showMixer.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.show-mixer"));
        this.showTransport = new MenuItem(this.menu, 32);
        this.showTransport.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.show-transport"));
        this.showFretBoard = new MenuItem(this.menu, 32);
        this.showFretBoard.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.show-fretboard"));
        this.showPiano = new MenuItem(this.menu, 32);
        this.showPiano.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.show-piano"));
        this.showMatrix = new MenuItem(this.menu, 32);
        this.showMatrix.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.show-matrix"));
        new MenuItem(this.menu, 2);
        this.pageLayout = new MenuItem(this.menu, 16);
        this.pageLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-page"));
        this.linearLayout = new MenuItem(this.menu, 16);
        this.linearLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-linear"));
        this.multitrack = new MenuItem(this.menu, 32);
        this.multitrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-multitrack"));
        this.scoreEnabled = new MenuItem(this.menu, 32);
        this.scoreEnabled.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-score-enabled"));
        this.tablatureEnabled = new MenuItem(this.menu, 32);
        this.tablatureEnabled.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-tablature-enabled"));
        this.compact = new MenuItem(this.menu, 32);
        this.compact.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-compact"));
        new MenuItem(this.menu, 2);
        this.chordMenuItem = new MenuItem(this.menu, 64);
        this.chordMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.chordName = new MenuItem(this.chordMenu, 32);
        this.chordName.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-chord-name-enabled"));
        this.chordDiagram = new MenuItem(this.chordMenu, 32);
        this.chordDiagram.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.view.layout-set-chord-diagram-enabled"));
        this.chordMenuItem.setMenu(this.chordMenu);
        this.layoutMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        ViewLayout viewLayout = TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout();
        int n = viewLayout.getStyle();
        this.showMixer.setSelection(!TuxGuitar.instance().getMixer().isDisposed());
        this.showTransport.setSelection(!TuxGuitar.instance().getTransport().isDisposed());
        this.showFretBoard.setSelection(TuxGuitar.instance().getFretBoardEditor().isVisible());
        this.showPiano.setSelection(!TuxGuitar.instance().getPianoEditor().isDisposed());
        this.showMatrix.setSelection(!TuxGuitar.instance().getMatrixEditor().isDisposed());
        this.pageLayout.setSelection(viewLayout instanceof PageViewLayout);
        this.linearLayout.setSelection(viewLayout instanceof LinearViewLayout);
        this.multitrack.setSelection((n & 2) != 0);
        this.scoreEnabled.setSelection((n & 4) != 0);
        this.tablatureEnabled.setSelection((n & 8) != 0);
        this.compact.setSelection((n & 1) != 0);
        this.compact.setEnabled((n & 2) == 0 || viewLayout.getSongManager().getSong().countTracks() == 1);
        this.chordName.setSelection((n & 0x10) != 0);
        this.chordDiagram.setSelection((n & 0x20) != 0);
    }

    public void loadProperties() {
        this.layoutMenuItem.setText(TuxGuitar.getProperty("layout"));
        this.showMixer.setText(TuxGuitar.getProperty("show-mixer"));
        this.showTransport.setText(TuxGuitar.getProperty("show-transport"));
        this.showFretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
        this.showPiano.setText(TuxGuitar.getProperty("show-piano"));
        this.showMatrix.setText(TuxGuitar.getProperty("show-matrix"));
        this.pageLayout.setText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
        this.scoreEnabled.setText(TuxGuitar.getProperty("layout.score-enabled"));
        this.tablatureEnabled.setText(TuxGuitar.getProperty("layout.tablature-enabled"));
        this.compact.setText(TuxGuitar.getProperty("layout.compact"));
        this.chordMenuItem.setText(TuxGuitar.getProperty("layout.chord-style"));
        this.chordName.setText(TuxGuitar.getProperty("layout.chord-name"));
        this.chordDiagram.setText(TuxGuitar.getProperty("layout.chord-diagram"));
    }

    public void loadIcons() {
    }
}

