/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.items.MenuItems;

public class EditMenuItem
implements MenuItems {
    private MenuItem editMenuItem;
    private Menu menu;
    private MenuItem undo;
    private MenuItem redo;
    private MenuItem modeSelection;
    private MenuItem modeEdition;
    private MenuItem notNaturalKey;

    public EditMenuItem(Shell shell, Menu menu, int n) {
        this.editMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.undo = new MenuItem(this.menu, 8);
        this.undo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.undo"));
        this.redo = new MenuItem(this.menu, 8);
        this.redo.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.redo"));
        new MenuItem(this.menu, 2);
        this.modeSelection = new MenuItem(this.menu, 16);
        this.modeSelection.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-mouse-mode-selection"));
        this.modeEdition = new MenuItem(this.menu, 16);
        this.modeEdition.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = new MenuItem(this.menu, 32);
        this.notNaturalKey.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("action.edit.set-natural-key"));
        this.editMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        EditorKit editorKit = TuxGuitar.instance().getTablatureEditor().getTablature().getEditorKit();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.undo.setEnabled(!bl && TuxGuitar.instance().getUndoableManager().canUndo());
        this.redo.setEnabled(!bl && TuxGuitar.instance().getUndoableManager().canRedo());
        this.modeSelection.setSelection(editorKit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!bl);
        this.modeEdition.setSelection(editorKit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!bl);
        this.notNaturalKey.setSelection(!editorKit.isNatural());
        this.notNaturalKey.setEnabled(!bl && editorKit.getMouseMode() == 2);
    }

    public void loadProperties() {
        this.editMenuItem.setText(TuxGuitar.getProperty("edit.menu"));
        this.undo.setText(TuxGuitar.getProperty("edit.undo"));
        this.redo.setText(TuxGuitar.getProperty("edit.redo"));
        this.modeSelection.setText(TuxGuitar.getProperty("edit.mouse-mode-selection"));
        this.modeEdition.setText(TuxGuitar.getProperty("edit.mouse-mode-edition"));
        this.notNaturalKey.setText(TuxGuitar.getProperty("edit.not-natural-key"));
    }

    public void loadIcons() {
        this.undo.setImage(TuxGuitar.instance().getIconManager().getEditUndo());
        this.redo.setImage(TuxGuitar.instance().getIconManager().getEditRedo());
    }
}

