/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGTrackImpl
extends TGTrack {
    private int tabHeight;
    private int scoreHeight;

    public TGTrackImpl(TGFactory tGFactory) {
        super(tGFactory);
    }

    public void update(ViewLayout viewLayout) {
        this.calculateTabHeight(viewLayout);
        this.calculateScoreHeight(viewLayout);
    }

    public void calculateTabHeight(ViewLayout viewLayout) {
        this.tabHeight = (viewLayout.getStyle() & 8) != 0 ? (this.stringCount() - 1) * viewLayout.getStringSpacing() : 0;
    }

    public void calculateScoreHeight(ViewLayout viewLayout) {
        this.scoreHeight = (viewLayout.getStyle() & 4) != 0 ? viewLayout.getScoreLineSpacing() * 5 : 0;
    }

    public boolean hasCaret(ViewLayout viewLayout) {
        return this.equals(viewLayout.getTablature().getCaret().getTrack());
    }

    public int getTabHeight() {
        return this.tabHeight;
    }

    public int getScoreHeight() {
        return this.scoreHeight;
    }

    public void setTabHeight(int n) {
        this.tabHeight = n;
    }

    public void clear() {
        Iterator iterator = this.getMeasures();
        while (iterator.hasNext()) {
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)iterator.next();
            if (tGMeasureImpl.isDisposed()) continue;
            tGMeasureImpl.dispose();
        }
        super.clear();
    }

    public void removeMeasure(int n) {
        TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)this.getMeasure(n);
        if (!tGMeasureImpl.isDisposed()) {
            tGMeasureImpl.dispose();
        }
        super.removeMeasure(n);
    }
}

