/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGBeatGroup;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGKeySignaturePainter;
import org.herac.tuxguitar.gui.editors.tab.painters.TGNotePainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;

public class TGNoteImpl
extends TGNote {
    public static final int NATURAL = 0;
    public static final int SHARP = 1;
    public static final int FLAT = 2;
    public static final int[][] KEY_SIGNATURES = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 2}, {0, 0, 2, 0, 0, 0, 2}, {0, 0, 2, 0, 0, 2, 2}, {0, 2, 2, 0, 0, 2, 2}, {0, 2, 2, 0, 2, 2, 2}, {2, 2, 2, 0, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2}};
    public static final int[] SCORE_SHARP_NOTES = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
    public static final int[] SCORE_FLAT_NOTES = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
    public static final boolean[] NO_NATURAL_NOTES = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    private int realValue = -1;
    private TGBeatGroup group;
    private Rectangle noteOrientation = new Rectangle(0, 0, 0, 0);
    private int tabPosY;
    private int scorePosY;

    public TGNoteImpl(TGFactory tGFactory) {
        super(tGFactory);
    }

    public void update(ViewLayout viewLayout) {
        this.realValue = -1;
        this.tabPosY = this.getString() * viewLayout.getStringSpacing() - viewLayout.getStringSpacing();
        this.scorePosY = this.group.getY1(viewLayout, this, this.getMeasureImpl().getKeySignature(), this.getMeasureImpl().getClef());
    }

    public void paint(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        int n3 = this.getBeatImpl().getSpacing();
        this.paintScoreNote(viewLayout, tGPainter, n, n2 + this.getPaintPosition(6), n3);
        if (!viewLayout.isPlayModeEnabled()) {
            this.paintOfflineEffects(viewLayout, tGPainter, n, n2, n3);
        }
        this.paintTablatureNote(viewLayout, tGPainter, n, n2 + this.getPaintPosition(16), n3);
    }

    private void paintOfflineEffects(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        int n4;
        int n5;
        TGNoteEffect tGNoteEffect = this.getEffect();
        viewLayout.setOfflineEffectStyle(tGPainter);
        if (tGNoteEffect.isAccentuatedNote()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(9);
            this.paintAccentuated(viewLayout, tGPainter, n5, n4);
        } else if (tGNoteEffect.isHeavyAccentuatedNote()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(9);
            this.paintHeavyAccentuated(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isFadeIn()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(14);
            this.paintFadeIn(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isHarmonic() && (viewLayout.getStyle() & 4) == 0) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(10);
            String string = new String();
            string = tGNoteEffect.getHarmonic().isNatural() ? "N.H" : string;
            string = tGNoteEffect.getHarmonic().isArtificial() ? "A.H" : string;
            string = tGNoteEffect.getHarmonic().isTapped() ? "T.H" : string;
            string = tGNoteEffect.getHarmonic().isPinch() ? "P.H" : string;
            string = tGNoteEffect.getHarmonic().isSemi() ? "S.H" : string;
            tGPainter.drawString(string, n5, n4);
        }
        if (tGNoteEffect.isTapping()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(11);
            tGPainter.drawString("T", n5, n4);
        } else if (tGNoteEffect.isSlapping()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(11);
            tGPainter.drawString("S", n5, n4);
        } else if (tGNoteEffect.isPopping()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(11);
            tGPainter.drawString("P", n5, n4);
        }
        if (tGNoteEffect.isPalmMute()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(12);
            tGPainter.drawString("P.M", n5, n4);
        }
        if (tGNoteEffect.isVibrato()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(13);
            this.paintVibrato(viewLayout, tGPainter, n5, n4);
        }
        if (tGNoteEffect.isTrill()) {
            n5 = n + this.getPosX() + n3;
            n4 = n2 + this.getPaintPosition(13);
            this.paintTrill(viewLayout, tGPainter, n5, n4);
        }
    }

    public void paintTablatureNote(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        int n4 = viewLayout.getStyle();
        if ((n4 & 8) != 0) {
            int n5 = viewLayout.getStringSpacing();
            int n6 = n + this.getPosX() + n3 + 2;
            int n7 = n2 + this.getTabPosY();
            this.noteOrientation.x = n6;
            this.noteOrientation.y = n7;
            this.noteOrientation.width = 1;
            this.noteOrientation.height = 1;
            viewLayout.setTabNoteStyle(tGPainter, viewLayout.isPlayModeEnabled() && this.getBeatImpl().isPlaying(viewLayout));
            if (this.isTiedNote() && (n4 & 4) == 0) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = n5 * 3;
                TGNoteImpl tGNoteImpl = this.getNoteForTie();
                if (tGNoteImpl != null) {
                    f = n + tGNoteImpl.getPosX() + tGNoteImpl.getBeatImpl().getSpacing();
                    f2 = n2 + tGNoteImpl.getTabPosY() + n5;
                    f3 = (float)n6 - f;
                } else {
                    Rectangle rectangle = viewLayout.getNoteOrientation(tGPainter, n6, n7, this);
                    f = rectangle.x - n5 * 2;
                    f2 = n2 + this.getTabPosY() + n5;
                    f3 = n5 * 2;
                }
                tGPainter.initPath();
                tGPainter.addArc(f, f2 - f4, f3, f4, 225.0f, 90.0f);
                tGPainter.closePath();
            } else if (!this.isTiedNote()) {
                Rectangle rectangle = viewLayout.getNoteOrientation(tGPainter, n6, n7, this);
                this.noteOrientation.x = rectangle.x;
                this.noteOrientation.y = rectangle.y;
                this.noteOrientation.width = rectangle.width;
                this.noteOrientation.height = rectangle.height;
                String string = this.getEffect().isDeadNote() ? "X" : Integer.toString(this.getValue());
                string = this.getEffect().isGhostNote() ? "(" + string + ")" : string;
                tGPainter.drawString(string, this.noteOrientation.x, this.noteOrientation.y);
            }
            if (!viewLayout.isPlayModeEnabled()) {
                this.paintEffects(viewLayout, tGPainter, n, n2, n3);
                if ((n4 & 4) == 0) {
                    int n8 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n5 / 2;
                    int n9 = n2 + this.getMeasureImpl().getTrackImpl().getTabHeight() + n5 / 2 * 5;
                    if (this.getEffect().isTremoloPicking()) {
                        viewLayout.setTabEffectStyle(tGPainter);
                        tGPainter.initPath();
                        int n10 = n8 + (n9 - n8) / 2;
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            tGPainter.moveTo(n6 - 3, n10 - 1);
                            tGPainter.lineTo(n6 + 4, n10 + 1);
                            n10 += 4;
                        }
                        tGPainter.setLineWidth(2);
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                }
            }
        }
    }

    private void paintScoreNote(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        if ((viewLayout.getStyle() & 4) != 0) {
            int n4;
            int n5;
            float f = viewLayout.getScoreLineSpacing();
            int n6 = this.group.getDirection();
            int n7 = this.getMeasureImpl().getKeySignature();
            int n8 = this.getMeasureImpl().getClef();
            int n9 = this.getRealValue();
            int n10 = n + this.getPosX() + n3;
            int n11 = n2 + this.getScorePosY();
            boolean bl = viewLayout.isPlayModeEnabled() && this.getBeatImpl().isPlaying(viewLayout);
            viewLayout.setScoreNoteStyle(tGPainter, bl);
            if (this.isTiedNote()) {
                TGNoteImpl tGNoteImpl = this.getNoteForTie();
                float f2 = f / 8.0f;
                float f3 = (float)n10 - 20.0f * f2;
                float f4 = (float)n11 - 2.0f * f2;
                float f5 = 20.0f * f2;
                float f6 = 30.0f * f2;
                if (tGNoteImpl != null) {
                    n5 = n + tGNoteImpl.getPosX() + tGNoteImpl.getBeatImpl().getSpacing();
                    n4 = n2 + this.getScorePosY();
                    f3 = (float)n5 + 6.0f * f2;
                    f4 = (float)n4 - 3.0f * f2;
                    f5 = (float)(n10 - n5) - 3.0f * f2;
                    f6 = 35.0f * f2;
                }
                tGPainter.initPath();
                tGPainter.addArc(f3, f4, f5, f6, 45.0f, 90.0f);
                tGPainter.closePath();
            }
            boolean bl2 = KEY_SIGNATURES[n7][SCORE_SHARP_NOTES[n9 % 12]] == 1;
            boolean bl3 = KEY_SIGNATURES[n7][SCORE_FLAT_NOTES[n9 % 12]] == 2;
            boolean bl4 = NO_NATURAL_NOTES[n9 % 12];
            if (n7 <= 7) {
                if (bl4 && !bl2) {
                    tGPainter.initPath(2);
                    TGKeySignaturePainter.paintSharp(tGPainter, (float)n10 - (f - f / 4.0f), (float)n11 + f / 2.0f, f);
                    tGPainter.closePath();
                }
                if (bl2 && !bl4) {
                    tGPainter.initPath(2);
                    TGKeySignaturePainter.paintNatural(tGPainter, (float)n10 - (f - f / 4.0f), (float)n11 + f / 2.0f, f);
                    tGPainter.closePath();
                }
            } else {
                if (bl4 && !bl3) {
                    tGPainter.initPath(2);
                    TGKeySignaturePainter.paintFlat(tGPainter, (float)n10 - (f - f / 4.0f), (float)n11 + f / 2.0f, f);
                    tGPainter.closePath();
                }
                if (bl3 && !bl4) {
                    tGPainter.initPath(2);
                    TGKeySignaturePainter.paintNatural(tGPainter, (float)n10 - (f - f / 4.0f), (float)n11 + f / 2.0f, f);
                    tGPainter.closePath();
                }
            }
            if (this.getEffect().isHarmonic()) {
                tGPainter.drawImage(viewLayout.getResources().getHarmonicNote(this.getBeat().getDuration().getValue(), bl), n10, n11);
            } else {
                tGPainter.drawImage(viewLayout.getResources().getScoreNote(this.getBeat().getDuration().getValue(), bl), n10, n11);
            }
            if (!viewLayout.isPlayModeEnabled()) {
                if (this.getEffect().isGrace()) {
                    this.paintGrace(viewLayout, tGPainter, n10, n11);
                }
                if (this.getBeat().getDuration().isDotted() || this.getBeat().getDuration().isDoubleDotted()) {
                    this.getBeatImpl().paintDot(viewLayout, tGPainter, (float)n10 + 12.0f * (f / 8.0f), n11 + viewLayout.getScoreLineSpacing() / 2, f / 10.0f);
                }
                if (this.getBeat().getDuration().getValue() >= 2) {
                    viewLayout.setScoreNoteFooterStyle(tGPainter);
                    int n12 = n6 == 1 ? viewLayout.getResources().getScoreNoteWidth() : 0;
                    int n13 = n2 + this.group.getY2(viewLayout, this.getPosX() + n3, n7, n8);
                    if (this.getEffect().isStaccato()) {
                        int n14 = 3;
                        n5 = n10 + n12;
                        n4 = n13 + 4 * (n6 == 1 ? -1 : 1);
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath(2);
                        tGPainter.moveTo(n5 - n14 / 2, n4 - n14 / 2);
                        tGPainter.addOval(n5 - n14 / 2, n4 - n14 / 2, n14, n14);
                        tGPainter.closePath();
                    }
                    if (this.getEffect().isTremoloPicking()) {
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath();
                        int n15 = n2;
                        n15 = n6 == 1 ? (n15 += this.group.getMaxNote().getScorePosY() - viewLayout.getScoreLineSpacing() - 4) : (n15 += this.group.getMinNote().getScorePosY() + viewLayout.getScoreLineSpacing() + 4);
                        for (n5 = 8; n5 <= this.getEffect().getTremoloPicking().getDuration().getValue(); n5 += n5) {
                            tGPainter.moveTo(n10 + n12 - 3, n15 + 1);
                            tGPainter.lineTo(n10 + n12 + 4, n15 - 1);
                            n15 += 4;
                        }
                        tGPainter.setLineWidth(2);
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                } else {
                    if (this.getEffect().isStaccato()) {
                        int n16 = 3;
                        int n17 = n10 + viewLayout.getResources().getScoreNoteWidth() / 2;
                        int n18 = n2 + this.group.getMinNote().getScorePosY() + viewLayout.getScoreLineSpacing() + 2;
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath(2);
                        tGPainter.moveTo(n17 - n16 / 2, n18 - n16 / 2);
                        tGPainter.addOval(n17 - n16 / 2, n18 - n16 / 2, n16, n16);
                        tGPainter.closePath();
                    }
                    if (this.getEffect().isTremoloPicking()) {
                        viewLayout.setScoreEffectStyle(tGPainter);
                        tGPainter.initPath();
                        int n19 = n10 + viewLayout.getResources().getScoreNoteWidth() / 2;
                        int n20 = n2 + (this.group.getMaxNote().getScorePosY() - viewLayout.getScoreLineSpacing() - 4);
                        for (int i = 8; i <= this.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                            tGPainter.moveTo(n19 - 3, n20 + 1);
                            tGPainter.lineTo(n19 + 4, n20 - 1);
                            n20 += 4;
                        }
                        tGPainter.setLineWidth(2);
                        tGPainter.closePath();
                        tGPainter.setLineWidth(1);
                    }
                }
            }
        }
    }

    private TGNoteImpl getNoteForTie() {
        for (int i = this.getMeasureImpl().countBeats() - 1; i >= 0; --i) {
            TGBeat tGBeat = this.getMeasureImpl().getBeat(i);
            if (tGBeat.getStart() >= this.getBeat().getStart() || tGBeat.isRestBeat()) continue;
            Iterator iterator = tGBeat.getNotes().iterator();
            while (iterator.hasNext()) {
                TGNoteImpl tGNoteImpl = (TGNoteImpl)iterator.next();
                if (tGNoteImpl.getString() != this.getString()) continue;
                return tGNoteImpl;
            }
        }
        return null;
    }

    private void paintEffects(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2, int n3) {
        Object object;
        int n4 = n + this.getPosX() + n3;
        int n5 = n2 + this.getTabPosY();
        TGNoteEffect tGNoteEffect = this.getEffect();
        if (tGNoteEffect.isGrace()) {
            viewLayout.setGraceStyle(tGPainter);
            String string = Integer.toString(tGNoteEffect.getGrace().getFret());
            object = tGPainter.getStringExtent(string);
            tGPainter.drawString(string, this.noteOrientation.x - object.x - 2, this.noteOrientation.y);
        }
        if (tGNoteEffect.isBend()) {
            this.paintBend(viewLayout, tGPainter, this.noteOrientation.x + this.noteOrientation.width, n5);
        } else if (tGNoteEffect.isTremoloBar()) {
            this.paintTremoloBar(viewLayout, tGPainter, this.noteOrientation.x + this.noteOrientation.width, n5);
        } else if (tGNoteEffect.isSlide() || tGNoteEffect.isHammer()) {
            int n6 = n;
            object = (TGNoteImpl)viewLayout.getSongManager().getMeasureManager().getNextNote(this.getMeasureImpl(), this.getBeat().getStart(), this.getString());
            if (tGNoteEffect.isSlide()) {
                this.paintSlide(viewLayout, tGPainter, (TGNoteImpl)object, n4, n5, n6);
            } else if (tGNoteEffect.isHammer()) {
                this.paintHammer(viewLayout, tGPainter, (TGNoteImpl)object, n4, n5, n6);
            }
        }
    }

    private void paintBend(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = (float)n + 1.0f * f;
        float f3 = (float)n2 - 2.0f * f;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3);
        tGPainter.lineTo(f2 + 1.0f * f, f3);
        tGPainter.cubicTo(f2 + 1.0f * f, f3, f2 + 3.0f * f, f3, f2 + 3.0f * f, f3 - 2.0f * f);
        tGPainter.lineTo(f2 + 3.0f * f, f3 - 12.0f * f);
        tGPainter.lineTo(f2 + 1.0f * f, f3 - 10.0f * f);
        tGPainter.moveTo(f2 + 3.0f * f, f3 - 12.0f * f);
        tGPainter.lineTo(f2 + 5.0f * f, f3 - 10.0f * f);
        tGPainter.closePath();
    }

    private void paintTremoloBar(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = (float)n + 1.0f * f;
        float f3 = f2 + 8.0f * f;
        float f4 = n2;
        float f5 = f4 + 9.0f * f;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath();
        tGPainter.moveTo(f2, f4);
        tGPainter.lineTo(f2 + (f3 - f2) / 2.0f, f5);
        tGPainter.lineTo(f3, f4);
        tGPainter.closePath();
    }

    private void paintSlide(ViewLayout viewLayout, TGPainter tGPainter, TGNoteImpl tGNoteImpl, int n, int n2, int n3) {
        float f = viewLayout.getScale();
        float f2 = (float)viewLayout.getStringSpacing() / 10.0f;
        float f3 = 3.0f * f2;
        float f4 = n;
        float f5 = n2;
        viewLayout.setTabEffectStyle(tGPainter);
        if (tGNoteImpl != null) {
            float f6 = tGNoteImpl.getPosX() + n3 + tGNoteImpl.getBeatImpl().getSpacing();
            float f7 = f5;
            if (tGNoteImpl.getValue() < this.getValue()) {
                f5 -= f3;
                f7 += f3;
            } else if (tGNoteImpl.getValue() > this.getValue()) {
                f5 += f3;
                f7 -= f3;
            } else {
                f5 -= f3;
                f7 -= f3;
            }
            tGPainter.initPath();
            tGPainter.moveTo(f4 + 6.0f * f, f5);
            tGPainter.lineTo(f6 - 3.0f * f, f7);
            tGPainter.closePath();
        } else {
            tGPainter.initPath();
            tGPainter.moveTo(f4 + 6.0f * f, f5 - f3);
            tGPainter.lineTo(f4 + 17.0f * f, f5 - f3);
            tGPainter.closePath();
        }
    }

    private void paintHammer(ViewLayout viewLayout, TGPainter tGPainter, TGNoteImpl tGNoteImpl, int n, int n2, int n3) {
        float f = viewLayout.getScale();
        float f2 = (float)viewLayout.getStringSpacing() / 10.0f;
        float f3 = (float)n + 7.0f * f;
        float f4 = (float)n2 - 5.0f * f2;
        float f5 = tGNoteImpl != null ? (float)(tGNoteImpl.getPosX() + n3 + tGNoteImpl.getBeatImpl().getSpacing()) - 4.0f * f - f3 : 10.0f * f;
        float f6 = 15.0f * f2;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath();
        tGPainter.addArc(f3, f4, f5, f6, 45.0f, 90.0f);
        tGPainter.closePath();
    }

    private void paintGrace(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = (float)viewLayout.getScoreLineSpacing() / 2.25f;
        float f2 = (float)n - 2.0f * f;
        float f3 = (float)n2 + f / 3.0f;
        viewLayout.setTabEffectStyle(tGPainter);
        tGPainter.initPath(2);
        TGNotePainter.paintFooter(tGPainter, f2, f3, -1, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3 - 2.0f * f);
        tGPainter.lineTo(f2, f3 + 2.0f * f - f / 4.0f);
        tGPainter.closePath();
        tGPainter.initPath(3);
        TGNotePainter.paintNote(tGPainter, f2 - f * 1.33f, f3 + f + f / 4.0f, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(f2 - f, f3);
        tGPainter.lineTo(f2 + f, f3 - f);
        tGPainter.closePath();
    }

    private void paintVibrato(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = (float)n2 + 2.0f * f;
        float f4 = (float)this.getBeatImpl().getWidth() - 2.0f * f;
        int n3 = (int)(f4 / (6.0f * f));
        if (n3 > 0) {
            int n4;
            viewLayout.setTabEffectStyle(tGPainter);
            tGPainter.initPath(2);
            tGPainter.moveTo(f2 + 2.0f * f, f3 + 1.0f * f);
            for (n4 = 0; n4 < n3; ++n4) {
                f2 = (float)n + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
                tGPainter.cubicTo(f2 + 2.0f * f, f3 + 1.0f * f, f2 + 3.0f * f, f3, f2 + 4.0f * f, f3 + 1.0f * f);
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 3.0f * f);
            }
            tGPainter.lineTo(f2 + 7.0f * f, f3 + 2.0f * f);
            tGPainter.cubicTo(f2 + 7.0f * f, f3 + 2.0f * f, f2 + 8.0f * f, f3 + 2.0f * f, f2 + 7.0f * f, f3 + 3.0f * f);
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                f2 = (float)n + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 4.0f * f);
                tGPainter.cubicTo(f2 + 6.0f * f, f3 + 4.0f * f, f2 + 5.0f * f, f3 + 5.0f * f, f2 + 4.0f * f, f3 + 4.0f * f);
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 2.0f * f);
                tGPainter.lineTo(f2 + 1.0f * f, f3 + 3.0f * f);
            }
            tGPainter.cubicTo(f2 + 1.0f * f, f3 + 3.0f * f, f2, f3 + 3.0f * f, f2 + 1.0f * f, f3 + 2.0f * f);
            tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
            tGPainter.closePath();
        }
    }

    private void paintTrill(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        String string = "Tr";
        Point point = tGPainter.getStringExtent(string);
        float f = viewLayout.getScale();
        float f2 = n + point.x;
        float f3 = (float)n2 + ((float)point.y - 5.0f * f) / 2.0f;
        float f4 = (float)(this.getBeatImpl().getWidth() - point.x) - 2.0f * f;
        int n3 = (int)(f4 / (6.0f * f));
        if (n3 > 0) {
            int n4;
            tGPainter.drawString(string, n, n2);
            viewLayout.setTabEffectStyle(tGPainter);
            tGPainter.initPath(2);
            tGPainter.moveTo(f2 + 2.0f * f, f3 + 1.0f * f);
            for (n4 = 0; n4 < n3; ++n4) {
                f2 = (float)(n + point.x) + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
                tGPainter.cubicTo(f2 + 2.0f * f, f3 + 1.0f * f, f2 + 3.0f * f, f3, f2 + 4.0f * f, f3 + 1.0f * f);
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 3.0f * f);
            }
            tGPainter.lineTo(f2 + 7.0f * f, f3 + 2.0f * f);
            tGPainter.cubicTo(f2 + 7.0f * f, f3 + 2.0f * f, f2 + 8.0f * f, f3 + 2.0f * f, f2 + 7.0f * f, f3 + 3.0f * f);
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                f2 = (float)(n + point.x) + 6.0f * f * (float)n4;
                tGPainter.lineTo(f2 + 6.0f * f, f3 + 4.0f * f);
                tGPainter.cubicTo(f2 + 6.0f * f, f3 + 4.0f * f, f2 + 5.0f * f, f3 + 5.0f * f, f2 + 4.0f * f, f3 + 4.0f * f);
                tGPainter.lineTo(f2 + 2.0f * f, f3 + 2.0f * f);
                tGPainter.lineTo(f2 + 1.0f * f, f3 + 3.0f * f);
            }
            tGPainter.cubicTo(f2 + 1.0f * f, f3 + 3.0f * f, f2, f3 + 3.0f * f, f2 + 1.0f * f, f3 + 2.0f * f);
            tGPainter.lineTo(f2 + 2.0f * f, f3 + 1.0f * f);
            tGPainter.closePath();
        }
    }

    private void paintFadeIn(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = (float)n2 + 4.0f * f;
        float f4 = this.getBeatImpl().getWidth();
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3);
        tGPainter.cubicTo(f2, f3, f2 + f4, f3, f2 + f4, f3 - 4.0f * f);
        tGPainter.moveTo(f2, f3);
        tGPainter.cubicTo(f2, f3, f2 + f4, f3, f2 + f4, f3 + 4.0f * f);
        tGPainter.closePath();
    }

    private void paintAccentuated(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = (float)n2 + 1.0f * f;
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3);
        tGPainter.lineTo(f2 + 6.0f * f, f3 + 2.5f * f);
        tGPainter.lineTo(f2, f3 + 5.0f * f);
        tGPainter.closePath();
    }

    private void paintHeavyAccentuated(ViewLayout viewLayout, TGPainter tGPainter, int n, int n2) {
        float f = viewLayout.getScale();
        float f2 = n;
        float f3 = n2;
        tGPainter.initPath();
        tGPainter.moveTo(f2, f3 + 5.0f * f);
        tGPainter.lineTo(f2 + 3.0f * f, f3 + 1.0f * f);
        tGPainter.lineTo(f2 + 6.0f * f, f3 + 5.0f * f);
        tGPainter.closePath();
    }

    public int getRealValue() {
        if (this.realValue < 0) {
            this.realValue = this.getValue() + this.getMeasureImpl().getTrack().getString(this.getString()).getValue();
        }
        return this.realValue;
    }

    public int getScorePosY() {
        return this.scorePosY;
    }

    public int getTabPosY() {
        return this.tabPosY;
    }

    public TGMeasureImpl getMeasureImpl() {
        return this.getBeatImpl().getMeasureImpl();
    }

    public int getPaintPosition(int n) {
        return this.getMeasureImpl().getTs().getPosition(n);
    }

    public TGBeatImpl getBeatImpl() {
        return (TGBeatImpl)super.getBeat();
    }

    public TGBeatGroup getBeatGroup() {
        return this.group;
    }

    public void setBeatGroup(TGBeatGroup tGBeatGroup) {
        this.group = tGBeatGroup;
    }

    public int getPosX() {
        return this.getBeatImpl().getPosX();
    }
}

