/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.matrix;

import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class MatrixConfig {
    private Font font;
    private Color[] colorLines;
    private Color colorForeground;
    private Color colorBorder;
    private Color colorPosition;
    private Color colorNote;
    private Color colorPlay;
    private static final int MINIMUN_CONTROL_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;

    public Font getFont() {
        return this.font;
    }

    public Color getColorForeground() {
        return this.colorForeground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public Color getColorPosition() {
        return this.colorPosition;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorPlay() {
        return this.colorPlay;
    }

    public Color[] getColorLines() {
        return this.colorLines;
    }

    public Color getColorLine(int n) {
        return this.colorLines[n];
    }

    public void load() {
        Display display = TuxGuitar.instance().getDisplay();
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        this.font = new Font((Device)display, tGConfigManager.getFontDataConfigValue("matrix.font"));
        this.colorForeground = new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.foreground"));
        this.colorBorder = new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.border"));
        this.colorPosition = new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.position"));
        this.colorNote = new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.note"));
        this.colorPlay = new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.play-note"));
        this.colorLines = new Color[]{new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.line-1")), new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.line-2")), new Color((Device)display, tGConfigManager.getRGBConfigValue("matrix.color.line-3"))};
    }

    public void defaults() {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        Properties properties = tGConfigManager.getDefaults();
        tGConfigManager.setProperty("matrix.font", properties.getProperty("matrix.font"));
        tGConfigManager.setProperty("matrix.color.foreground", properties.getProperty("matrix.color.foreground"));
        tGConfigManager.setProperty("matrix.color.border", properties.getProperty("matrix.color.border"));
        tGConfigManager.setProperty("matrix.color.position", properties.getProperty("matrix.color.position"));
        tGConfigManager.setProperty("matrix.color.note", properties.getProperty("matrix.color.note"));
        tGConfigManager.setProperty("matrix.color.play-note", properties.getProperty("matrix.color.play-note"));
        tGConfigManager.setProperty("matrix.color.line-1", properties.getProperty("matrix.color.line-1"));
        tGConfigManager.setProperty("matrix.color.line-2", properties.getProperty("matrix.color.line-2"));
        tGConfigManager.setProperty("matrix.color.line-3", properties.getProperty("matrix.color.line-3"));
    }

    public void save(FontData fontData, RGB rGB, RGB rGB2, RGB rGB3, RGB rGB4, RGB rGB5, RGB[] rGBArray) {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        tGConfigManager.setProperty("matrix.font", fontData);
        tGConfigManager.setProperty("matrix.color.foreground", rGB);
        tGConfigManager.setProperty("matrix.color.border", rGB2);
        tGConfigManager.setProperty("matrix.color.position", rGB3);
        tGConfigManager.setProperty("matrix.color.note", rGB4);
        tGConfigManager.setProperty("matrix.color.play-note", rGB5);
        tGConfigManager.setProperty("matrix.color.line-1", rGBArray[0]);
        tGConfigManager.setProperty("matrix.color.line-2", rGBArray[1]);
        tGConfigManager.setProperty("matrix.color.line-3", rGBArray[2]);
    }

    public void dispose() {
        this.dispose((Resource)this.font);
        this.dispose((Resource)this.colorForeground);
        this.dispose((Resource)this.colorBorder);
        this.dispose((Resource)this.colorPosition);
        this.dispose((Resource)this.colorNote);
        this.dispose((Resource)this.colorPlay);
        this.dispose((Resource[])this.colorLines);
    }

    protected void dispose(Resource[] resourceArray) {
        if (resourceArray != null) {
            for (int i = 0; i < resourceArray.length; ++i) {
                this.dispose(resourceArray[i]);
            }
        }
    }

    protected void dispose(Resource resource) {
        if (resource != null) {
            resource.dispose();
        }
    }

    public void configure(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("matrix.settings"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("matrix.settings"));
        final FontData fontData = this.getFontChooser((Composite)group, TuxGuitar.getProperty("matrix.font"), this.font.getFontData()[0]);
        final RGB rGB = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.foreground-color"), this.colorForeground.getRGB());
        final RGB[] rGBArray = new RGB[]{this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.line-color-1"), this.colorLines[0].getRGB()), this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.line-color-2"), this.colorLines[1].getRGB()), this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.line-color-over"), this.colorLines[2].getRGB())};
        final RGB rGB2 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.border-color"), this.colorBorder.getRGB());
        final RGB rGB3 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.position-color"), this.colorPosition.getRGB());
        final RGB rGB4 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.note-color"), this.colorNote.getRGB());
        final RGB rGB5 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("matrix.play-note-color"), this.colorPlay.getRGB());
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("defaults"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                MatrixConfig.this.defaults();
                MatrixConfig.this.applyChanges();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                MatrixConfig.this.save(fontData, rGB, rGB2, rGB3, rGB4, rGB5, rGBArray);
                MatrixConfig.this.applyChanges();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        DialogUtils.openDialog(shell2, 11);
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(final Composite composite, String string, RGB rGB) {
        final RGB rGB2 = new RGB(rGB.red, rGB.green, rGB.blue);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        final Button button = new Button(composite, 8);
        button.setLayoutData((Object)this.getAlignmentData(180, 4));
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color((Device)composite.getDisplay(), rGB2);
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.setBackground(color);
                tGPainter.initPath(2);
                tGPainter.addRectangle(5.0f, 5.0f, button.getSize().x - 10, button.getSize().y - 10);
                tGPainter.closePath();
                tGPainter.dispose();
                color.dispose();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(composite.getShell());
                colorDialog.setRGB(rGB2);
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    rGB2.red = rGB.red;
                    rGB2.green = rGB.green;
                    rGB2.blue = rGB.blue;
                    button.redraw();
                }
            }
        });
        return rGB2;
    }

    private FontData getFontChooser(final Composite composite, String string, FontData fontData) {
        final FontData fontData2 = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)this.getAlignmentData(180, 4));
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Font font = new Font((Device)composite.getDisplay(), fontData2);
                FontDialog fontDialog = new FontDialog(composite.getShell());
                fontDialog.setFontList(font.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData != null) {
                    fontData2.setName(fontData.getName());
                    fontData2.setHeight(fontData.getHeight());
                    fontData2.setStyle(fontData.getStyle());
                }
                font.dispose();
            }
        });
        return fontData2;
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }
}

