/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.lyric;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.lyric.LyricEditor;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackLyric;
import org.herac.tuxguitar.song.models.TGTrack;

public class LyricModifyListener
implements ModifyListener {
    private boolean enabled;
    private LyricEditor editor;
    private int lastPosition;

    public LyricModifyListener(LyricEditor lyricEditor) {
        this.editor = lyricEditor;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (this.isEnabled() && !TuxGuitar.instance().getPlayer().isRunning()) {
            if (modifyEvent.widget instanceof Text) {
                TGTrack tGTrack = this.editor.getTrack();
                Text text = (Text)modifyEvent.widget;
                String string = text.getText();
                int n = text.getCaretPosition();
                UndoableTrackLyric undoableTrackLyric = UndoableTrackLyric.startUndo(tGTrack, this.lastPosition);
                tGTrack.getLyrics().setLyrics(string);
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackLyric.endUndo(tGTrack, n));
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                this.lastPosition = n;
            } else if (modifyEvent.widget instanceof Spinner) {
                TGTrack tGTrack = this.editor.getTrack();
                UndoableTrackLyric undoableTrackLyric = UndoableTrackLyric.startUndo(tGTrack, this.lastPosition);
                tGTrack.getLyrics().setFrom(((Spinner)modifyEvent.widget).getSelection());
                TuxGuitar.instance().getUndoableManager().addEdit(undoableTrackLyric.endUndo(tGTrack, this.lastPosition));
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
            }
            TuxGuitar.instance().updateCache(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

