/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;

public class TremoloPickingEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    private Button thirtySecondButton;
    private Button sixTeenthButton;
    private Button eighthButton;
    protected TGEffectTremoloPicking result;

    public TGEffectTremoloPicking show(final TGNote tGNote) {
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(TuxGuitar.getProperty("effects.tremolo-picking-editor"));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        int n = 2;
        int n2 = 8;
        if (tGNote.getEffect().isTremoloPicking()) {
            n2 = tGNote.getEffect().getTremoloPicking().getDuration().getValue();
        }
        Group group = this.makeGroup(composite, n, TuxGuitar.getProperty("duration"));
        group.setLayout((Layout)new GridLayout(3, false));
        this.thirtySecondButton = new Button((Composite)group, 16);
        this.thirtySecondButton.setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.thirtySecondButton.setLayoutData((Object)this.makeGridData(1));
        this.thirtySecondButton.setSelection(n2 == 32);
        this.sixTeenthButton = new Button((Composite)group, 16);
        this.sixTeenthButton.setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.sixTeenthButton.setLayoutData((Object)this.makeGridData(1));
        this.sixTeenthButton.setSelection(n2 == 16);
        this.eighthButton = new Button((Composite)group, 16);
        this.eighthButton.setImage(TuxGuitar.instance().getIconManager().getDuration(8));
        this.eighthButton.setLayoutData((Object)this.makeGridData(1));
        this.eighthButton.setSelection(n2 == 8);
        Composite composite2 = new Composite((Composite)shell, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(0x1000008, 1024, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloPickingEditor.this.result = TremoloPickingEditor.this.getTremoloPicking();
                shell.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloPickingEditor.this.result = null;
                shell.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TremoloPickingEditor.this.result = tGNote.getEffect().getTremoloPicking();
                shell.dispose();
            }
        });
        DialogUtils.openDialog(shell, 11);
        return this.result;
    }

    private Group makeGroup(Composite composite, int n, String string) {
        Group group = new Group(composite, 16);
        group.setLayoutData((Object)this.makeGridData(n));
        group.setText(string);
        return group;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        return gridData;
    }

    public TGEffectTremoloPicking getTremoloPicking() {
        TGEffectTremoloPicking tGEffectTremoloPicking = TuxGuitar.instance().getSongManager().getFactory().newEffectTremoloPicking();
        if (this.thirtySecondButton.getSelection()) {
            tGEffectTremoloPicking.getDuration().setValue(32);
        } else if (this.sixTeenthButton.getSelection()) {
            tGEffectTremoloPicking.getDuration().setValue(16);
        } else if (this.eighthButton.getSelection()) {
            tGEffectTremoloPicking.getDuration().setValue(8);
        } else {
            return null;
        }
        return tGEffectTremoloPicking;
    }
}

