/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;

public class BendEditor {
    public static final int X_SPACING = 30;
    public static final int Y_SPACING = 15;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 13;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List points;
    protected Composite editor;
    protected DefaultBend[] defaultBends;
    protected TGEffectBend result;

    public BendEditor() {
        this.init();
    }

    private void init() {
        int n;
        this.x = new int[13];
        this.y = new int[13];
        this.width = 360;
        this.height = 180;
        this.points = new ArrayList();
        for (n = 0; n < this.x.length; ++n) {
            this.x[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.y.length; ++n) {
            this.y[n] = (n + 1) * 15;
        }
    }

    public TGEffectBend show(Shell shell, final TGNote tGNote) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("bend.editor"));
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor = new Composite(composite2, 0x20000800);
        this.editor.setBackground(this.editor.getDisplay().getSystemColor(1));
        this.editor.setLayoutData((Object)this.resizeData(new GridData(4, 4, true, true), this.getWidth() + 60, this.getHeight() + 30));
        this.editor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                BendEditor.this.paintEditor(tGPainter);
                tGPainter.dispose();
            }
        });
        this.editor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                BendEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                BendEditor.this.editor.redraw();
            }
        });
        this.resetDefaultBends();
        final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite3, 2052);
        for (int i = 0; i < this.defaultBends.length; ++i) {
            list.add(this.defaultBends[i].getName());
        }
        list.select(0);
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = list.getSelectionIndex();
                if (n >= 0 && n < BendEditor.this.defaultBends.length) {
                    BendEditor.this.setBend(BendEditor.this.defaultBends[list.getSelectionIndex()].getBend());
                    BendEditor.this.editor.redraw();
                }
            }
        });
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, true), 80, 25));
        button.setText(TuxGuitar.getProperty("clean"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BendEditor.this.result = null;
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BendEditor.this.result = BendEditor.this.getBend();
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite3, 8);
        button3.setLayoutData((Object)this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BendEditor.this.result = tGNote.getEffect().getBend();
                shell2.dispose();
            }
        });
        if (tGNote.getEffect().isBend()) {
            this.setBend(tGNote.getEffect().getBend());
        } else {
            this.setBend(this.defaultBends[0].getBend());
        }
        DialogUtils.openDialog(shell2, 11);
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n, int n2) {
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    protected void paintEditor(TGPainter tGPainter) {
        Point point;
        int n;
        for (n = 0; n < this.x.length; ++n) {
            this.setStyleX(tGPainter, n);
            tGPainter.initPath();
            tGPainter.moveTo(this.x[n], 15.0f);
            tGPainter.lineTo(this.x[n], 15 + this.height);
            tGPainter.closePath();
        }
        for (n = 0; n < this.y.length; ++n) {
            this.setStyleY(tGPainter, n);
            tGPainter.initPath();
            tGPainter.moveTo(30.0f, this.y[n]);
            tGPainter.lineTo(30 + this.width, this.y[n]);
            tGPainter.closePath();
        }
        Iterator iterator = null;
        Point point2 = null;
        tGPainter.setLineStyle(1);
        tGPainter.setLineWidth(2);
        tGPainter.setForeground(this.editor.getDisplay().getSystemColor(15));
        iterator = this.points.iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            if (point2 != null) {
                tGPainter.initPath();
                tGPainter.moveTo(point2.x, point2.y);
                tGPainter.lineTo(point.x, point.y);
                tGPainter.closePath();
            }
            point2 = point;
        }
        tGPainter.setLineWidth(5);
        tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        iterator = this.points.iterator();
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            tGPainter.initPath();
            tGPainter.addRectangle(point.x - 2, point.y - 2, 5.0f, 5.0f);
            tGPainter.closePath();
        }
        tGPainter.setLineWidth(1);
    }

    private void setStyleX(TGPainter tGPainter, int n) {
        tGPainter.setLineStyle(1);
        if (n == 0 || n == 12) {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(9));
            if (n % 3 > 0) {
                tGPainter.setLineStyle(3);
            }
        }
    }

    private void setStyleY(TGPainter tGPainter, int n) {
        tGPainter.setLineStyle(1);
        if (n == 0 || n == 12) {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            tGPainter.setForeground(this.editor.getDisplay().getSystemColor(3));
            if (n % 2 > 0) {
                tGPainter.setLineStyle(3);
                tGPainter.setForeground(this.editor.getDisplay().getSystemColor(15));
            } else if (n % 4 > 0) {
                tGPainter.setLineStyle(3);
            }
        }
    }

    protected void checkPoint(int n, int n2) {
        Point point = new Point(this.getX(n), this.getY(n2));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    protected boolean removePoint(Point point) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point2 = (Point)iterator.next();
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    protected void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    protected void removePointsAtXLine(int n) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    protected void addPoint(Point point) {
        this.points.add(point);
    }

    protected int getX(int n) {
        int n2 = -1;
        for (int i = 0; i < this.x.length; ++i) {
            if (n2 < 0) {
                n2 = this.x[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.x[i]);
            if (n4 >= n3) continue;
            n2 = this.x[i];
        }
        return n2;
    }

    protected int getY(int n) {
        int n2 = -1;
        for (int i = 0; i < this.y.length; ++i) {
            if (n2 < 0) {
                n2 = this.y[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.y[i]);
            if (n4 >= n3) continue;
            n2 = this.y[i];
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public TGEffectBend getBend() {
        if (this.points != null && !this.points.isEmpty()) {
            TGEffectBend tGEffectBend = TuxGuitar.instance().getSongManager().getFactory().newEffectBend();
            Iterator iterator = this.points.iterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                this.addBendPoint(tGEffectBend, point);
            }
            return tGEffectBend;
        }
        return null;
    }

    private void addBendPoint(TGEffectBend tGEffectBend, Point point) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.x.length; ++n) {
            if (point.x != this.x[n]) continue;
            n2 = n;
        }
        for (n = 0; n < this.y.length; ++n) {
            if (point.y != this.y[n]) continue;
            n3 = this.y.length - n - 1;
        }
        tGEffectBend.addPoint(n2, n3);
    }

    public void setBend(TGEffectBend tGEffectBend) {
        this.points.clear();
        Iterator iterator = tGEffectBend.getPoints().iterator();
        while (iterator.hasNext()) {
            TGEffectBend.BendPoint bendPoint = (TGEffectBend.BendPoint)iterator.next();
            this.makePoint(bendPoint);
        }
    }

    private void makePoint(TGEffectBend.BendPoint bendPoint) {
        int n = bendPoint.getPosition();
        int n2 = this.y.length - bendPoint.getValue() - 1;
        if (n >= 0 && n < this.x.length && n2 >= 0 && n2 < this.y.length) {
            Point point = new Point(0, 0);
            point.x = this.x[n];
            point.y = this.y[n2];
            this.points.add(point);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void resetDefaultBends() {
        this.defaultBends = new DefaultBend[5];
        this.defaultBends[0] = new DefaultBend(TuxGuitar.getProperty("bend.bend"), TuxGuitar.instance().getSongManager().getFactory().newEffectBend());
        this.defaultBends[0].getBend().addPoint(0, 0);
        this.defaultBends[0].getBend().addPoint(6, 4);
        this.defaultBends[0].getBend().addPoint(12, 4);
        this.defaultBends[1] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release"), TuxGuitar.instance().getSongManager().getFactory().newEffectBend());
        this.defaultBends[1].getBend().addPoint(0, 0);
        this.defaultBends[1].getBend().addPoint(3, 4);
        this.defaultBends[1].getBend().addPoint(6, 4);
        this.defaultBends[1].getBend().addPoint(9, 0);
        this.defaultBends[1].getBend().addPoint(12, 0);
        this.defaultBends[2] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release-bend"), TuxGuitar.instance().getSongManager().getFactory().newEffectBend());
        this.defaultBends[2].getBend().addPoint(0, 0);
        this.defaultBends[2].getBend().addPoint(2, 4);
        this.defaultBends[2].getBend().addPoint(4, 4);
        this.defaultBends[2].getBend().addPoint(6, 0);
        this.defaultBends[2].getBend().addPoint(8, 0);
        this.defaultBends[2].getBend().addPoint(10, 4);
        this.defaultBends[2].getBend().addPoint(12, 4);
        this.defaultBends[3] = new DefaultBend(TuxGuitar.getProperty("bend.prebend"), TuxGuitar.instance().getSongManager().getFactory().newEffectBend());
        this.defaultBends[3].getBend().addPoint(0, 4);
        this.defaultBends[3].getBend().addPoint(12, 4);
        this.defaultBends[4] = new DefaultBend(TuxGuitar.getProperty("bend.prebend-release"), TuxGuitar.instance().getSongManager().getFactory().newEffectBend());
        this.defaultBends[4].getBend().addPoint(0, 4);
        this.defaultBends[4].getBend().addPoint(4, 4);
        this.defaultBends[4].getBend().addPoint(8, 0);
        this.defaultBends[4].getBend().addPoint(12, 0);
    }

    private class DefaultBend {
        private String name;
        private TGEffectBend bend;

        public DefaultBend(String string, TGEffectBend tGEffectBend) {
            this.name = string;
            this.bend = tGEffectBend;
        }

        public TGEffectBend getBend() {
            return this.bend;
        }

        public String getName() {
            return this.name;
        }
    }
}

