/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import org.herac.tuxguitar.gui.editors.chord.ChordDatabase;

public class ChordNamingConvention {
    public String createChordName(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTonic(n, bl2));
        String string = ChordDatabase.get(n2).getName();
        if (!string.equals("M")) {
            stringBuffer.append(string);
        }
        if (bl) {
            stringBuffer.append("add");
        }
        if (n3 != 0) {
            char c = stringBuffer.toString().charAt(stringBuffer.toString().length() - 1);
            if (c >= '0' && c <= '9') {
                stringBuffer.append("/");
            }
            switch (n3) {
                case 1: {
                    stringBuffer.append(this.getAdd("9", n4));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.getAdd("11", n4));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.getAdd("13", n4));
                }
            }
        }
        if (n5 != 0) {
            stringBuffer.append("/").append(this.getAdd("5", n5));
        }
        if (n6 != 0) {
            stringBuffer.append("/").append(this.getAdd("9", n6));
        }
        if (n7 != 0) {
            stringBuffer.append("/").append(this.getAdd("11", n7));
        }
        if (n != n8) {
            stringBuffer.append(" \\");
            stringBuffer.append(this.getTonic(n8, bl2));
        }
        return stringBuffer.toString();
    }

    public String getTonic(int n, boolean bl) {
        String string;
        switch (n) {
            case 0: {
                string = "C";
                break;
            }
            case 1: {
                string = bl ? "C#" : "Db";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = bl ? "D#" : "Eb";
                break;
            }
            case 4: {
                string = "E";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 6: {
                string = bl ? "F#" : "Gb";
                break;
            }
            case 7: {
                string = "G";
                break;
            }
            case 8: {
                string = bl ? "G#" : "Ab";
                break;
            }
            case 9: {
                string = "A";
                break;
            }
            case 10: {
                string = bl ? "A#" : "Bb";
                break;
            }
            default: {
                string = "B";
            }
        }
        return string;
    }

    private String getAdd(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        switch (n) {
            case 1: {
                stringBuffer.append("+");
                break;
            }
            case 2: {
                stringBuffer.append("-");
            }
        }
        return stringBuffer.toString();
    }
}

