/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.ChordDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.TGChord;

public class ChordCustomList
extends Composite {
    private ChordDialog dialog;
    private List chords;

    public ChordCustomList(ChordDialog chordDialog, Composite composite, int n, int n2) {
        super(composite, n);
        this.setLayout((Layout)chordDialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(this.makeGridData(n2));
        this.dialog = chordDialog;
        this.init();
    }

    public GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 128, true, true);
        gridData.heightHint = n;
        return gridData;
    }

    public void init() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chords = new List(composite, 2816);
        this.chords.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordCustomList.this.getDialog().getEditor() != null) {
                    ChordCustomList.this.showChord(ChordCustomList.this.getChords().getSelectionIndex());
                }
            }
        });
        Composite composite2 = new Composite((Composite)this, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("add"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordCustomList.this.addCustomChord();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("rename"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordCustomList.this.renameCustomChord(ChordCustomList.this.getChords().getSelectionIndex());
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("remove"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordCustomList.this.removeCustomChord(ChordCustomList.this.getChords().getSelectionIndex());
            }
        });
        this.loadChords();
    }

    private void loadChords() {
        int n = this.chords.getSelectionIndex();
        this.chords.removeAll();
        for (int i = 0; i < TuxGuitar.instance().getCustomChordManager().countChords(); ++i) {
            TGChord tGChord = TuxGuitar.instance().getCustomChordManager().getChord(i);
            if (tGChord == null) continue;
            this.chords.add(tGChord.getName());
        }
        if (n >= 0 && n < this.chords.getItemCount()) {
            this.chords.select(n);
        } else if (n > 0 && n - 1 < this.chords.getItemCount()) {
            this.chords.select(n - 1);
        }
    }

    protected void showChord(int n) {
        TGChord tGChord = TuxGuitar.instance().getCustomChordManager().getChord(n);
        if (tGChord != null) {
            this.dialog.getEditor().setChord(tGChord);
        }
    }

    protected void addCustomChord() {
        TGChord tGChord = this.dialog.getEditor().getChord();
        if (tGChord != null) {
            NameDialog nameDialog = new NameDialog();
            nameDialog.name = this.dialog.getEditor().getChordName().getText().trim();
            String string = nameDialog.open();
            if (string != null) {
                if (string.length() == 0) {
                    MessageDialog.errorMessage(this.getShell(), TuxGuitar.getProperty("chord.custom.name-empty-error"));
                    return;
                }
                if (TuxGuitar.instance().getCustomChordManager().existOtherEqualCustomChord(string, -1)) {
                    MessageDialog.errorMessage(this.getShell(), TuxGuitar.getProperty("chord.custom.name-exist-error"));
                    return;
                }
                tGChord.setName(string);
                TuxGuitar.instance().getCustomChordManager().addChord(tGChord);
                this.loadChords();
            }
        }
    }

    protected void renameCustomChord(int n) {
        String string;
        TGChord tGChord = TuxGuitar.instance().getCustomChordManager().getChord(n);
        if (tGChord != null && (string = new NameDialog(tGChord.getName()).open()) != null) {
            if (string.length() == 0) {
                MessageDialog.errorMessage(this.getShell(), TuxGuitar.getProperty("chord.custom.name-empty-error"));
                return;
            }
            if (TuxGuitar.instance().getCustomChordManager().existOtherEqualCustomChord(string, n)) {
                MessageDialog.errorMessage(this.getShell(), TuxGuitar.getProperty("chord.custom.name-exist-error"));
                return;
            }
            TuxGuitar.instance().getCustomChordManager().renameChord(n, string);
            this.loadChords();
        }
    }

    protected void removeCustomChord(int n) {
        if (n >= 0 && n < TuxGuitar.instance().getCustomChordManager().countChords()) {
            TuxGuitar.instance().getCustomChordManager().removeChord(n);
            this.loadChords();
        }
    }

    protected ChordDialog getDialog() {
        return this.dialog;
    }

    protected List getChords() {
        return this.chords;
    }

    private class NameDialog {
        protected String name;

        public NameDialog(String string) {
            this.name = string;
        }

        public NameDialog() {
            this(new String());
        }

        public String open() {
            final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
            shell.setLayout((Layout)new GridLayout());
            shell.setText(TuxGuitar.getProperty("chord.custom"));
            Group group = new Group((Composite)shell, 16);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("chord.custom"));
            Composite composite = new Composite((Composite)group, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)this.getMainData());
            Label label = new Label(composite, 16384);
            label.setText(TuxGuitar.getProperty("chord.name") + ":");
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
            final Text text = new Text(composite, 2052);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(this.name);
            Composite composite2 = new Composite((Composite)shell, 0);
            composite2.setLayout((Layout)new GridLayout(2, false));
            composite2.setLayoutData((Object)new GridData(131072, 4, true, true));
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData((Object)this.getButtonData());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NameDialog.this.name = text.getText();
                    shell.dispose();
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData((Object)this.getButtonData());
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NameDialog.this.name = null;
                    shell.dispose();
                }
            });
            DialogUtils.openDialog(shell, 11);
            return this.name;
        }

        private GridData getMainData() {
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 300;
            return gridData;
        }

        private GridData getButtonData() {
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            return gridData;
        }
    }
}

