/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.clipboard.ClipBoard;
import org.herac.tuxguitar.gui.editors.tab.Tablature;

public class TablatureEditor {
    private Tablature tablature;
    private ClipBoard clipBoard = new ClipBoard();

    public void showTablature(Composite composite) {
        this.tablature = new Tablature(composite, 0x20000B00);
        this.tablature.initGUI();
        this.tablature.setSongManager(TuxGuitar.instance().getSongManager());
        this.tablature.reloadViewLayout();
        this.tablature.initDefaults();
        this.tablature.updateTablature();
        this.tablature.initCaret();
        this.tablature.setFocus();
        this.initKeyActions();
        this.initMenu();
    }

    private void initKeyActions() {
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo((Control)this.tablature);
    }

    private void initMenu() {
        Menu menu = TuxGuitar.instance().getItemManager().getPopupMenu();
        menu.addMenuListener((MenuListener)this.getTablature().getEditorKit());
        this.tablature.setMenu(menu);
    }

    public void reloadConfig() {
        this.getTablature().reloadStyles();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public ClipBoard getClipBoard() {
        return this.clipBoard;
    }
}

