/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.TGPainterUtils;

public class TGPainter {
    public static final int PATH_DRAW = 1;
    public static final int PATH_FILL = 2;
    private boolean pathEmpty;
    private int style;
    private GC gc;
    private Path path;

    public TGPainter(GC gC) {
        this.gc = gC;
    }

    public TGPainter(Image image) {
        this(new GC((Drawable)image));
    }

    public void initPath(int n) {
        this.style = n;
        this.path = new Path(this.gc.getDevice());
        this.pathEmpty = true;
    }

    public void initPath() {
        this.initPath(1);
    }

    public void closePath() {
        if (this.pathEmpty) {
            System.out.println("Warning: Empty Path!");
        }
        if ((this.style & 1) != 0) {
            TGPainterUtils.beforePath(this.gc);
            this.gc.drawPath(this.path);
        }
        if ((this.style & 2) != 0) {
            TGPainterUtils.beforePath(this.gc);
            this.gc.fillPath(this.path);
        }
        this.style = 0;
        this.path.dispose();
        this.pathEmpty = true;
    }

    public GC getGC() {
        return this.gc;
    }

    public void dispose() {
        this.gc.dispose();
    }

    public void setBackground(Color color) {
        this.gc.setBackground(color);
    }

    public void setFont(Font font) {
        this.gc.setFont(font);
    }

    public void setForeground(Color color) {
        this.gc.setForeground(color);
    }

    public void setLineStyle(int n) {
        this.gc.setLineStyle(n);
    }

    public void setLineWidth(int n) {
        this.gc.setLineWidth(n);
    }

    public void setAlpha(int n) {
        this.gc.setAlpha(n);
    }

    public void copyArea(Image image, int n, int n2) {
        this.gc.copyArea(image, n, n2);
    }

    public Point getStringExtent(String string) {
        TGPainterUtils.beforeString(this.gc);
        return this.gc.stringExtent(string);
    }

    public void drawString(String string, int n, int n2) {
        TGPainterUtils.beforeString(this.gc);
        this.gc.drawString(string, n, n2);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        TGPainterUtils.beforeString(this.gc);
        this.gc.drawString(string, n, n2, bl);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        TGPainterUtils.beforeImage(this.gc);
        this.gc.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void drawImage(Image image, int n, int n2) {
        TGPainterUtils.beforeImage(this.gc);
        this.gc.drawImage(image, n, n2);
    }

    public void drawPolygon(int[] nArray) {
        this.gc.drawPolygon(nArray);
    }

    public void fillPolygon(int[] nArray) {
        this.gc.fillPolygon(nArray);
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.path.cubicTo(f, f2, f3, f4, f5, f6);
        this.pathEmpty = false;
    }

    public void lineTo(float f, float f2) {
        this.path.lineTo(f, f2);
        this.pathEmpty = false;
    }

    public void moveTo(float f, float f2) {
        this.path.moveTo(f, f2);
        this.pathEmpty = false;
    }

    public void addString(String string, float f, float f2, Font font) {
        this.path.addString(string, f, f2, font);
        this.pathEmpty = false;
    }

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        this.path.addArc(f, f2, f3, f4, f5, f6);
        this.pathEmpty = false;
    }

    public void addOval(float f, float f2, float f3, float f4) {
        this.path.addArc(f, f2, f3, f4, 0.0f, 360.0f);
        this.pathEmpty = false;
    }

    public void addRectangle(float f, float f2, float f3, float f4) {
        this.path.addRectangle(f, f2, f3, f4);
        this.pathEmpty = false;
    }

    public void addRectangle(Rectangle rectangle) {
        this.path.addRectangle((float)rectangle.x, (float)rectangle.y, (float)rectangle.width, (float)rectangle.height);
        this.pathEmpty = false;
    }
}

