/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.player.base.MidiPlayerMode;

public class TransportModeAction
extends Action {
    public static final String NAME = "action.transport.mode";
    protected static final int MIN_SELECTION = 1;
    protected static final int MAX_SELECTION = 500;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};
    protected Button single;
    protected Button singleLoop;
    protected Combo singlePercent;
    protected Button custom;
    protected Spinner customFrom;
    protected Spinner customTo;
    protected Spinner customIncrement;

    public TransportModeAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(typedEvent.widget.getDisplay().getActiveShell(), TuxGuitar.instance().getPlayer().getMode());
        return 0;
    }

    public void showDialog(Shell shell, final MidiPlayerMode midiPlayerMode) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("transport.mode"));
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getMainData());
        this.single = new Button(composite, 16);
        this.single.setText(TuxGuitar.getProperty("transport.mode.single"));
        this.single.setSelection(midiPlayerMode.getType() == 1);
        RadioSelectionAdapter radioSelectionAdapter = new RadioSelectionAdapter(this.single);
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("transport.mode.single"));
        radioSelectionAdapter.addControl((Control)group);
        radioSelectionAdapter.addControl((Control)this.makeLabel((Composite)group, TuxGuitar.getProperty("transport.mode.single.tempo-percent"), 16384, 1));
        this.singlePercent = new Combo((Composite)group, 12);
        this.singlePercent.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < DEFAULT_PERCENTS.length; ++i) {
            this.singlePercent.add(Integer.toString(DEFAULT_PERCENTS[i]) + "%", i);
            if (midiPlayerMode.getSinglePercent() != DEFAULT_PERCENTS[i]) continue;
            this.singlePercent.select(i);
        }
        radioSelectionAdapter.addControl((Control)this.singlePercent);
        this.singleLoop = new Button((Composite)group, 32);
        this.singleLoop.setText(TuxGuitar.getProperty("transport.mode.single.loop"));
        this.singleLoop.setSelection(midiPlayerMode.isLoop());
        radioSelectionAdapter.addControl((Control)this.singleLoop);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.singleLoop.setLayoutData((Object)gridData);
        this.custom = new Button(composite, 16);
        this.custom.setText(TuxGuitar.getProperty("transport.mode.trainer"));
        this.custom.setSelection(midiPlayerMode.getType() == 2);
        RadioSelectionAdapter radioSelectionAdapter2 = new RadioSelectionAdapter(this.custom);
        Group group2 = new Group(composite, 16);
        group2.setLayout((Layout)new GridLayout(6, false));
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(TuxGuitar.getProperty("transport.mode.trainer"));
        radioSelectionAdapter2.addControl((Control)group2);
        radioSelectionAdapter2.addControl((Control)this.makeLabel((Composite)group2, TuxGuitar.getProperty("composition.tempo"), 16384, 1));
        this.customFrom = new Spinner((Composite)group2, 2048);
        this.customFrom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customFrom.setMinimum(1);
        this.customFrom.setMaximum(500);
        this.customFrom.setSelection(midiPlayerMode.getCustomPercentFrom());
        radioSelectionAdapter2.addControl((Control)this.customFrom);
        radioSelectionAdapter2.addControl((Control)this.makeLabel((Composite)group2, "%", 16384, 1));
        radioSelectionAdapter2.addControl((Control)this.makeLabel((Composite)group2, TuxGuitar.getProperty("edit.to"), 131072, 1));
        this.customTo = new Spinner((Composite)group2, 2048);
        this.customTo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customTo.setMinimum(1);
        this.customTo.setMaximum(500);
        this.customTo.setSelection(midiPlayerMode.getCustomPercentTo());
        radioSelectionAdapter2.addControl((Control)this.customTo);
        radioSelectionAdapter2.addControl((Control)this.makeLabel((Composite)group2, "%", 16384, 1));
        radioSelectionAdapter2.addControl((Control)this.makeLabel((Composite)group2, TuxGuitar.getProperty("transport.mode.trainer.increment-description"), 16384, 4));
        this.customIncrement = new Spinner((Composite)group2, 2048);
        this.customIncrement.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customIncrement.setMinimum(1);
        this.customIncrement.setMaximum(500);
        this.customIncrement.setSelection(midiPlayerMode.getCustomPercentIncrement());
        radioSelectionAdapter2.addControl((Control)this.customIncrement);
        radioSelectionAdapter2.addControl((Control)this.makeLabel((Composite)group2, "%", 16384, 1));
        SpinnerSelectionAdapter spinnerSelectionAdapter = new SpinnerSelectionAdapter(this.customFrom, this.customTo, this.customIncrement);
        this.customFrom.addSelectionListener((SelectionListener)spinnerSelectionAdapter);
        this.customTo.addSelectionListener((SelectionListener)spinnerSelectionAdapter);
        this.customIncrement.addSelectionListener((SelectionListener)spinnerSelectionAdapter);
        radioSelectionAdapter.update();
        radioSelectionAdapter2.update();
        Composite composite2 = new Composite((Composite)shell2, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransportModeAction.this.updateMode(midiPlayerMode);
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        DialogUtils.openDialog(shell2, 11);
    }

    private GridData getMainData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 350;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private Label makeLabel(Composite composite, String string, int n, int n2) {
        Label label = new Label(composite, 0x1000000 | n);
        label.setText(string);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.horizontalSpan = n2;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected void updateMode(MidiPlayerMode midiPlayerMode) {
        int n = this.custom.getSelection() ? 2 : 1;
        midiPlayerMode.setType(n);
        midiPlayerMode.setLoop(n == 2 || n == 1 && this.singleLoop.getSelection());
        midiPlayerMode.setSinglePercent(this.singlePercent.getSelectionIndex() >= 0 ? DEFAULT_PERCENTS[this.singlePercent.getSelectionIndex()] : 100);
        midiPlayerMode.setCustomPercentFrom(this.customFrom.getSelection());
        midiPlayerMode.setCustomPercentTo(this.customTo.getSelection());
        midiPlayerMode.setCustomPercentIncrement(this.customIncrement.getSelection());
        midiPlayerMode.reset();
    }

    private class SpinnerSelectionAdapter
    extends SelectionAdapter {
        private Spinner to;
        private Spinner from;
        private Spinner increment;

        public SpinnerSelectionAdapter(Spinner spinner, Spinner spinner2, Spinner spinner3) {
            this.from = spinner;
            this.to = spinner2;
            this.increment = spinner3;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget.equals(this.from)) {
                if (this.from.getSelection() < 1) {
                    this.from.setSelection(1);
                } else if (this.from.getSelection() >= this.to.getSelection()) {
                    this.from.setSelection(this.to.getSelection() - 1);
                }
            } else if (selectionEvent.widget.equals(this.to)) {
                if (this.to.getSelection() <= this.from.getSelection()) {
                    this.to.setSelection(this.from.getSelection() + 1);
                } else if (this.to.getSelection() > 500) {
                    this.to.setSelection(500);
                }
            }
            if (this.increment.getSelection() > this.to.getSelection() - this.from.getSelection()) {
                this.increment.setSelection(this.to.getSelection() - this.from.getSelection());
            }
        }
    }

    private class RadioSelectionAdapter
    extends SelectionAdapter {
        private Button control;
        private List controls = new ArrayList();

        public RadioSelectionAdapter(Button button) {
            this.control = button;
            this.control.addSelectionListener((SelectionListener)this);
        }

        public void addControl(Control control) {
            this.controls.add(control);
        }

        public void update() {
            boolean bl = this.control.getSelection();
            Iterator iterator = this.controls.iterator();
            while (iterator.hasNext()) {
                Control control = (Control)iterator.next();
                control.setEnabled(bl);
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.update();
        }
    }
}

