/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class AddMeasureAction
extends Action {
    public static final String NAME = "action.measure.add";
    protected int selectedNumber;

    public AddMeasureAction() {
        super(NAME, 27);
    }

    protected int execute(TypedEvent typedEvent) {
        final int n = this.showDialog();
        if (n > 0 && n <= this.getSongManager().getSong().countMeasureHeaders() + 1) {
            new Thread(new Runnable(){

                public void run() {
                    new SyncThread(new Runnable(){

                        public void run() {
                            UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo(n);
                            TuxGuitar.instance().getFileHistory().setUnsavedFile();
                            AddMeasureAction.this.getSongManager().addNewMeasure(n);
                            AddMeasureAction.this.updateTablature();
                            int n = AddMeasureAction.this.getEditor().getTablature().getCaret().getTrack().getNumber();
                            int n2 = AddMeasureAction.this.getEditor().getTablature().getCaret().getStringNumber();
                            long l = AddMeasureAction.this.getSongManager().getMeasureHeader(n).getStart();
                            AddMeasureAction.this.getEditor().getTablature().getCaret().update(n, l, n2);
                            AddMeasureAction.this.addUndoableEdit(undoableAddMeasure.endUndo());
                            TuxGuitar.instance().updateCache(true);
                        }
                    }).start();
                }
            }).start();
        }
        return 0;
    }

    public int showDialog() {
        this.selectedNumber = -1;
        if (this.getEditor().getTablature().getCaret().getMeasure() != null) {
            final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
            shell.setLayout((Layout)new GridLayout());
            shell.setText(TuxGuitar.getProperty("measure.add"));
            Group group = new Group((Composite)shell, 16);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("measure.add"));
            final Button button = new Button((Composite)group, 16);
            button.setText(TuxGuitar.getProperty("measure.add-before-current-position"));
            final Button button2 = new Button((Composite)group, 16);
            button2.setText(TuxGuitar.getProperty("measure.add-after-current-position"));
            final Button button3 = new Button((Composite)group, 16);
            button3.setText(TuxGuitar.getProperty("measure.add-at-end"));
            button3.setSelection(true);
            Composite composite = new Composite((Composite)shell, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            Button button4 = new Button(composite, 8);
            button4.setText(TuxGuitar.getProperty("ok"));
            button4.setLayoutData((Object)this.getButtonData());
            button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        AddMeasureAction.this.selectedNumber = AddMeasureAction.this.getEditor().getTablature().getCaret().getMeasure().getNumber();
                    } else if (button2.getSelection()) {
                        AddMeasureAction.this.selectedNumber = AddMeasureAction.this.getEditor().getTablature().getCaret().getMeasure().getNumber() + 1;
                    } else if (button3.getSelection()) {
                        AddMeasureAction.this.selectedNumber = AddMeasureAction.this.getSongManager().getSong().countMeasureHeaders() + 1;
                    }
                    shell.dispose();
                }
            });
            Button button5 = new Button(composite, 8);
            button5.setText(TuxGuitar.getProperty("cancel"));
            button5.setLayoutData((Object)this.getButtonData());
            button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell.dispose();
                }
            });
            DialogUtils.openDialog(shell, 11);
        }
        return this.selectedNumber;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }
}

