/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.gui.printer.PrintPreview;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.managers.TGSongManager;

public class PrintPreviewAction
extends Action {
    public static final String NAME = "action.file.print-preview";

    public PrintPreviewAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        final PrintDocumentData printDocumentData = PrintDocumentData.openDialog(TuxGuitar.instance().getShell());
        if (printDocumentData != null) {
            new SyncThread(new Runnable(){

                public void run() {
                    try {
                        PrintPreviewAction.this.printPreview(printDocumentData);
                    }
                    catch (Throwable throwable) {
                        MessageDialog.errorMessage(throwable);
                    }
                }
            }).start();
        }
        return 0;
    }

    public void printPreview(final PrintDocumentData printDocumentData) {
        TuxGuitar.instance().updateCache(false);
        TuxGuitar.instance().loadCursor(1);
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGSongManager tGSongManager = new TGSongManager();
                    tGSongManager.setFactory(new TGFactoryImpl());
                    tGSongManager.setSong(PrintPreviewAction.this.getSongManager().getSong().clone(tGSongManager.getFactory()));
                    PrintPreviewAction.this.printPreview(tGSongManager, printDocumentData);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }

    public void printPreview(final TGSongManager tGSongManager, final PrintDocumentData printDocumentData) {
        new SyncThread(new Runnable(){

            public void run() {
                try {
                    Tablature tablature = new Tablature(PrintPreviewAction.this.getEditor().getTablature());
                    tablature.setSongManager(tGSongManager);
                    PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, printDocumentData, 1.0f);
                    PrintPreviewAction.this.printPreview(printerViewLayout);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }

    public void printPreview(final PrinterViewLayout printerViewLayout) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    printerViewLayout.getTablature().updateTablature();
                    printerViewLayout.getTablature().getCaret().update(PrintPreviewAction.this.getEditor().getTablature().getCaret().getTrack().getNumber());
                    new SyncThread(new Runnable(){

                        public void run() {
                            PrintDocument printDocument = printerViewLayout.makeDocument(850, 1050);
                            printerViewLayout.getTablature().dispose();
                            PrintPreview printPreview = new PrintPreview(printDocument);
                            printPreview.showPreview(PrintPreviewAction.this.getEditor().getTablature().getShell());
                        }
                    }).start();
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }
}

