/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.effects.TrillEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class ChangeTrillNoteAction
extends Action {
    public static final String NAME = "action.note.effect.change-trill";

    public ChangeTrillNoteAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGNote tGNote = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (tGNote != null) {
            this.changeTrill(new TrillEditor().show(tGNote));
        }
        return 0;
    }

    private void changeTrill(TGEffectTrill tGEffectTrill) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        this.getSongManager().getMeasureManager().changeTrillNote(caret.getMeasure(), caret.getPosition(), caret.getSelectedString().getNumber(), tGEffectTrill);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

