/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;

public class ChangeDeadNoteAction
extends Action {
    public static final String NAME = "action.note.effect.change-dead";

    public ChangeDeadNoteAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        TGNote tGNote = caret.getSelectedNote();
        if (tGNote == null) {
            tGNote = this.getSongManager().getFactory().newNote();
            tGNote.setValue(0);
            tGNote.setVelocity(caret.getVelocity());
            tGNote.setString(caret.getSelectedString().getNumber());
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            caret.getDuration().copy(tGDuration);
            this.getSongManager().getMeasureManager().addNote(caret.getMeasure(), caret.getPosition(), tGNote, tGDuration);
        }
        this.getSongManager().getMeasureManager().changeDeadNote(tGNote);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

