/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeKeySignature;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGTrack;

public class ChangeKeySignatureAction
extends Action {
    public static final String NAME = "action.composition.change-key-signature";

    public ChangeKeySignatureAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.keysignature"));
            Group group = new Group((Composite)shell2, 16);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.keysignature"));
            Label label = new Label((Composite)group, 0);
            label.setText(TuxGuitar.getProperty("composition.keysignature") + ":");
            final Combo combo = new Combo((Composite)group, 12);
            combo.add(TuxGuitar.getProperty("composition.keysignature.natural"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-1"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-2"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-3"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-4"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-5"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-6"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.sharp-7"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-1"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-2"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-3"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-4"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-5"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-6"));
            combo.add(TuxGuitar.getProperty("composition.keysignature.flat-7"));
            combo.select(tGMeasureImpl.getKeySignature());
            combo.setLayoutData((Object)this.getComboData());
            Group group2 = new Group((Composite)shell2, 16);
            group2.setLayout((Layout)new GridLayout());
            group2.setLayoutData((Object)new GridData(4, 4, true, true));
            group2.setText(TuxGuitar.getProperty("options"));
            final Button button = new Button((Composite)group2, 32);
            button.setText(TuxGuitar.getProperty("composition.keysignature.to-the-end"));
            button.setSelection(true);
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData((Object)this.getButtonData());
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button.getSelection();
                    ChangeKeySignatureAction.this.setKeySignature(combo.getSelectionIndex(), bl);
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.setLayoutData((Object)this.getButtonData());
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData getComboData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        return gridData;
    }

    protected void setKeySignature(int n, boolean bl) {
        UndoableChangeKeySignature undoableChangeKeySignature = UndoableChangeKeySignature.startUndo();
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        TGTrackImpl tGTrackImpl = this.getEditor().getTablature().getCaret().getTrack();
        this.getSongManager().getTrackManager().changeKeySignature((TGTrack)tGTrackImpl, tGMeasureImpl.getStart(), n, bl);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableChangeKeySignature.endUndo(n, bl));
    }
}

