/*
 * ReportListenerElementsSelectionEvent.java
 *
 * Created on 17 giugno 2003, 1.12
 */

package it.businesslogic.ireport.gui.event;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;
/**
 * Save all info required by a ReportListenerElementsSelectionEvent
 * Return the vector of selected elements (taked by the JReportFrame...)
 * @author  Administrator
 */
public class ReportElementChangedEvent {
    
    private JReportFrame jReportFrame;
    
    /**
     *  The element was removed
     */
    public static final int REMOVED = 1;
    /**
     *  An element was added
     */
    public static final int ADDED   = 2;
    /**
     *  The element was changed
     */
    public static final int CHANGED = 3;

    /**
     *  The element that is changed/removed/added
     */
    private ReportElement element;
    
    /**
     *  The type of the element
     */
    private int type = 0;
    /** Creates a new instance of ReportListenerElementChangedEvent */
    public ReportElementChangedEvent(JReportFrame jReportFrame, ReportElement element, int type) {
        this.jReportFrame = jReportFrame;
        this.element = element;
        this.type = type;
    }
    
    /** Getter for property selectedElements.
     * @return Value of property selectedElements.
     *
     */
    public ReportElement getElement() {
        return element;
    }
    
    /** Setter for property selectedElements.
     * @param selectedElements New value of property selectedElements.
     *
     */
    public void setElement(ReportElement element) {
        this.element = element;
    }
    
    /** Getter for property type.
     *  Type can assume 3 values:
     *  REMOVED, ADDED, CHANGED 
     *  @return Value of property type.
     *  
     */
    public int getType() {
        return type;
    }
    
    /** Setter for property type.
     * @param type New value of property type.
     *
     */
    public void setType(int type) {
        this.type = type;
    }
    
    /** Getter for property jReportFrame.
     * @return Value of property jReportFrame.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame() {
        return jReportFrame;
    }
    
    /** Setter for property jReportFrame.
     * @param jReportFrame New value of property jReportFrame.
     *
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
    }
    
}
