/*
 * IReportFont.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 6 giugno 2003, 23.23
 */

package it.businesslogic.ireport;

/**
 *
 * @author  Administrator
 */
public class IReportFont {
    
    private boolean defaultFont = false;
    
    private String reportFont = "";
    
    private String fontName = "sansserif";
    
    private String PDFFontName = "helvetica";
    
    private int fontSize = 10;
    
    private String TTFFont = "";
    
    private boolean bold = false;
    
    private boolean underline = false;
    
    private boolean italic = false;
    
    private boolean strikeTrought = false;
    
    private boolean pdfEmbedded = false;
    
    private String pdfEncoding = "CP1252";
    
    
    /** Creates a new instance of IReportFont */
    public IReportFont() {
    }
    
    /** Getter for property bold.
     * @return Value of property bold.
     *
     */
    public boolean isBold() {
        return bold;
    }
    
    /** Setter for property bold.
     * @param bold New value of property bold.
     *
     */
    public void setBold(boolean bold) {
        this.bold = bold;
    }
    
    /** Getter for property fontName.
     * @return Value of property fontName.
     *
     */
    public java.lang.String getFontName() {
        return fontName;
    }
    
    /** Setter for property fontName.
     * @param fontName New value of property fontName.
     *
     */
    public void setFontName(java.lang.String fontName) {
        this.fontName = fontName;
    }
    
    /** Getter for property fontSize.
     * @return Value of property fontSize.
     *
     */
    public int getFontSize() {
        return fontSize;
    }
    
    /** Setter for property fontSize.
     * @param fontSize New value of property fontSize.
     *
     */
    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }
    
    /** Getter for property italic.
     * @return Value of property italic.
     *
     */
    public boolean isItalic() {
        return italic;
    }
    
    /** Setter for property italic.
     * @param italic New value of property italic.
     *
     */
    public void setItalic(boolean italic) {
        this.italic = italic;
    }
    
    /** Getter for property pdfEmbedded.
     * @return Value of property pdfEmbedded.
     *
     */
    public boolean isPdfEmbedded() {
        return pdfEmbedded;
    }
    
    /** Setter for property pdfEmbedded.
     * @param pdfEmbedded New value of property pdfEmbedded.
     *
     */
    public void setPdfEmbedded(boolean pdfEmbedded) {
        this.pdfEmbedded = pdfEmbedded;
    }
    
    /** Getter for property pdfEncoding.
     * @return Value of property pdfEncoding.
     *
     */
    public java.lang.String getPdfEncoding() {
        return pdfEncoding;
    }
    
    /** Setter for property pdfEncoding.
     * @param pdfEncoding New value of property pdfEncoding.
     *
     */
    public void setPdfEncoding(java.lang.String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }
    
    /** Getter for property PDFFontName.
     * @return Value of property PDFFontName.
     *
     */
    public java.lang.String getPDFFontName() {
        return PDFFontName;
    }
    
    /** Setter for property PDFFontName.
     * @param PDFFontName New value of property PDFFontName.
     *
     */
    public void setPDFFontName(java.lang.String PDFFontName) {
        this.PDFFontName = PDFFontName;
    }
    
    /** Getter for property reportFont.
     * @return Value of property reportFont.
     *
     */
    public java.lang.String getReportFont() {
        return reportFont;
    }
    
    /** Setter for property reportFont.
     * @param reportFont New value of property reportFont.
     *
     */
    public void setReportFont(java.lang.String reportFont) {
        this.reportFont = reportFont;
    }
    
    /** Getter for property strikeTrought.
     * @return Value of property strikeTrought.
     *
     */
    public boolean isStrikeTrought() {
        return strikeTrought;
    }
    
    /** Setter for property strikeTrought.
     * @param strikeTrought New value of property strikeTrought.
     *
     */
    public void setStrikeTrought(boolean strikeTrought) {
        this.strikeTrought = strikeTrought;
    }
    
    /** Getter for property TTFFont.
     * @return Value of property TTFFont.
     *
     */
    public java.lang.String getTTFFont() {
        return TTFFont;
    }
    
    /** Setter for property TTFFont.
     * @param TTFFont New value of property TTFFont.
     *
     */
    public void setTTFFont(java.lang.String TTFFont) {
        this.TTFFont = TTFFont;
    }
    
    /** Getter for property underline.
     * @return Value of property underline.
     *
     */
    public boolean isUnderline() {
        return underline;
    }
    
    /** Setter for property underline.
     * @param underline New value of property underline.
     *
     */
    public void setUnderline(boolean underline) {
        this.underline = underline;
    }
        
    public String toString()
    {
        return this.getReportFont();
    }
    
    public String getDescription()
    {
        return this.getFontName()+" "+this.getFontSize();
    }
    
    /** Getter for property defaultFont.
     * @return Value of property defaultFont.
     *
     */
    public boolean isDefaultFont() {
        return defaultFont;
    }
    
    /** Setter for property defaultFont.
     * @param defaultFont New value of property defaultFont.
     *
     */
    public void setDefaultFont(boolean defaultFont) {
        this.defaultFont = defaultFont;
    }
    
}
