/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.webLoader;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import slothLib.portUtil.PortUtil;
import slothLib.web.webLoader.HttpHeader;
import slothLib.web.webLoader.MultiWebGetResults;
import slothLib.web.webLoader.WebGetResult;

public class WebGet {
    private Proxy proxy = null;
    private String userAgent = "";

    public WebGetResult doFetch(String url, String outputName) {
        return this.doFetch(url, outputName, null, null);
    }

    public WebGetResult doFetch(String url) {
        return this.doFetch(url, null, null);
    }

    public WebGetResult doFetch(String url, String[] allowContentTypes, String[] excludeContentTypes) {
        return this.doFetch(url, this.getTempFileName(url), allowContentTypes, excludeContentTypes);
    }

    public MultiWebGetResults doFetch(String[] urlList, String[] allowContentTypes, String[] excludeContentTypes) {
        String[] tmpFileNameList = new String[urlList.length];
        int i = 0;
        while (i < urlList.length) {
            tmpFileNameList[i] = this.getTempFileName(urlList[i]);
            ++i;
        }
        return this.doFetch(urlList, tmpFileNameList, allowContentTypes, excludeContentTypes);
    }

    public MultiWebGetResults doFetch(String[] urlList) {
        return this.doFetch(urlList, null, null);
    }

    public WebGetResult doFetch(String url, String outputName, String[] allowContentTypes, String[] excludeContentTypes) {
        HttpURLConnection con;
        String status;
        HttpHeader header;
        block11: {
            String type;
            int n;
            int n2;
            String[] stringArray;
            String mainType;
            String contentType;
            block10: {
                header = new HttpHeader();
                status = "";
                con = this.proxy != null ? (HttpURLConnection)new URL(url).openConnection(this.proxy) : (HttpURLConnection)new URL(url).openConnection();
                if (!PortUtil.isNullOrEmpty(this.userAgent)) {
                    con.setRequestProperty("User-Agent", this.userAgent);
                }
                status = con.getResponseMessage();
                contentType = con.getContentType();
                mainType = contentType.substring(0, contentType.indexOf("/"));
                int iEncoding = contentType.indexOf(";");
                if (iEncoding >= 0) {
                    contentType = contentType.substring(0, iEncoding);
                }
                header = new HttpHeader(PortUtil.getCharacterSet(con), con.getContentEncoding(), con.getContentLength(), contentType, PortUtil.getCookies(con), new Date(con.getLastModified()), con.getRequestMethod(), PortUtil.getHttpVersion(con), con.getURL().toURI(), con.getURL().getHost(), con.getResponseCode(), con.getResponseMessage());
                if (allowContentTypes == null) break block10;
                ArrayList<String> allowList = new ArrayList<String>();
                stringArray = allowContentTypes;
                n2 = allowContentTypes.length;
                n = 0;
                while (n < n2) {
                    type = stringArray[n];
                    allowList.add(type);
                    ++n;
                }
                if (allowList.contains(contentType) || allowList.contains(mainType)) break block10;
                return null;
            }
            if (excludeContentTypes == null) break block11;
            ArrayList<String> excludeList = new ArrayList<String>();
            stringArray = excludeContentTypes;
            n2 = excludeContentTypes.length;
            n = 0;
            while (n < n2) {
                type = stringArray[n];
                excludeList.add(type);
                ++n;
            }
            if (!excludeList.contains(contentType) && !excludeList.contains(mainType)) break block11;
            return null;
        }
        try {
            int readCount;
            InputStream is = con.getInputStream();
            FileOutputStream os = new FileOutputStream(outputName);
            byte[] buf = new byte[8192];
            while ((readCount = is.read(buf)) >= 0) {
                System.out.println(readCount);
                os.write(buf, 0, readCount);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            status = String.valueOf(status) + ":  " + ex.getMessage();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        WebGetResult re = new WebGetResult(url, outputName, header, status);
        return re;
    }

    public MultiWebGetResults doFetch(String[] urlList, String[] outputFileList, String[] allowContentTypes, String[] excludeContentTypes) {
        ArrayList<WebGetResult> resultElements = new ArrayList<WebGetResult>();
        if (urlList.length < outputFileList.length) {
            System.err.println("WebGet:\u53d6\u5f97\u3059\u308bURL\u30ea\u30b9\u30c8\u3068\u5bfe\u5fdc\u3059\u308b\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d\u30ea\u30b9\u30c8\u306e\u8981\u7d20\u6570\u304c\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            return null;
        }
        int index = 0;
        while (index < urlList.length) {
            String url = urlList[index];
            String outputFile = outputFileList[index];
            WebGetResult result = this.doFetch(url, outputFile, allowContentTypes, excludeContentTypes);
            resultElements.add(result);
            ++index;
        }
        return new MultiWebGetResults(resultElements.toArray(new WebGetResult[0]));
    }

    private String getHashName(String url) {
        return String.valueOf(url.hashCode()) + "." + System.currentTimeMillis() + ".tmp";
    }

    private String getTempFileName(String url) {
        return String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + this.getHashName(url);
    }

    public void setProxy(String value) {
        this.proxy = value != null ? PortUtil.createProxy(value) : null;
    }

    public String getProxy() {
        if (this.proxy != null) {
            return PortUtil.getProxyURL(this.proxy);
        }
        return "";
    }

    public void setUserAgent(String value) {
        this.userAgent = value;
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

