/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.webLoader;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import slothLib.web.webLoader.MultiWebGetResults;
import slothLib.web.webLoader.WebGetManager;
import slothLib.web.webLoader.WebGetResult;

public class MultiWebGet {
    private int threadCount = 10;
    private String proxy = null;
    private String userAgent = null;
    private int count = 0;
    private static final int MAX_THREAD_COUNT = 20;
    private static final int DEFAULT_THREAD_COUNT = 10;
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(2, 10, 10L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());

    public MultiWebGetResults doFetch(String[] urlList) {
        return this.doFetch(urlList, null, null);
    }

    public MultiWebGetResults doFetch(String[] urlList, String[] outputFileList) {
        return this.doFetch(urlList, outputFileList, null, null);
    }

    public MultiWebGetResults doFetch(String[] urlList, String[] allowContentTypes, String[] excludeContentTypes) {
        String[] tmpFileNameList = new String[urlList.length];
        int i = 0;
        while (i < urlList.length) {
            tmpFileNameList[i] = this.getTempFileName(urlList[i]);
            ++i;
        }
        return this.doFetch(urlList, tmpFileNameList, allowContentTypes, excludeContentTypes);
    }

    public MultiWebGetResults doFetch(String[] urlList, String[] outputFileList, String[] allowContentTypes, String[] excludeContentTypes) {
        if (urlList.length > outputFileList.length) {
            System.err.println("MultiWebGet:\u53d6\u5f97\u3059\u308bURL\u30ea\u30b9\u30c8\u3068\u5bfe\u5fdc\u3059\u308b\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u540d\u30ea\u30b9\u30c8\u306e\u8981\u7d20\u6570\u304c\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            return null;
        }
        ArrayList<Future<WebGetResult>> futures = new ArrayList<Future<WebGetResult>>();
        WebGetResult[] results = new WebGetResult[urlList.length];
        int i = 0;
        while (i < urlList.length) {
            WebGetManager wgm = new WebGetManager(urlList[i], outputFileList[i], allowContentTypes, excludeContentTypes, this.proxy, this.userAgent);
            futures.add(threadPool.submit(wgm));
            ++i;
        }
        i = 0;
        while (i < urlList.length) {
            try {
                results[i] = (WebGetResult)((Future)futures.get(i)).get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return new MultiWebGetResults(results);
    }

    private String getHashName(String url) {
        return String.valueOf(url.hashCode()) + "." + System.currentTimeMillis() + ".tmp";
    }

    private String getTempFileName(String url) {
        return String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + this.getHashName(url);
    }

    public void setProxy(String value) {
        this.proxy = value;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setUserAgent(String value) {
        this.userAgent = value;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int value) {
        this.threadCount = value > 20 ? 20 : (value < 0 ? 1 : value);
        threadPool.setMaximumPoolSize(this.threadCount);
    }
}

