package test.org.seasar.util;

import junit.framework.*;
import org.seasar.util.*;

public class SeasarRuntimeExceptionTest extends TestCase {

    public SeasarRuntimeExceptionTest(String name) {
        super(name);
    }

    public void testSeasarRuntimeException() throws Exception {
        SeasarRuntimeException ex = new SeasarRuntimeException("ISSR0001");
        assertEquals("1", "ISSR0001", ex.getMessageCode());
        assertEquals("2", getClass().getName(), ex.getClassName());
        assertEquals("3", "testSeasarRuntimeException", ex.getMethodName());
        assertEquals("4", "[ISSR0001]seasar started", ex.getMessage());
    }

    public void testGetCause() throws Exception {
        try {
            throw new NullPointerException("test");
        } catch (Exception ex) {
            try {
                throw new SeasarRuntimeException("ESSR0017", new Object[]{ex}, ex);
            } catch (SeasarRuntimeException ce) {
                assertNotNull("1", ce.getCause());
                ce.printStackTrace();
            }
        }
    }

    protected void setUp() throws Exception { }

    protected void tearDown() throws Exception { }

    public static Test suite() {
        return new TestSuite(SeasarRuntimeExceptionTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{SeasarRuntimeExceptionTest.class.getName()});
    }
}
