package test.org.seasar.system;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.seasar.system.JMXService;
import org.seasar.system.MBeanProxy;
import org.seasar.util.Serializer;

public class MBeanProxyTest extends RMIAdaptorTestCase {

    public MBeanProxyTest(String name) throws Exception {
        super(name);
    }

	public void testCreate() throws Exception {
		HelloMBean proxy = (HelloMBean) MBeanProxy.create(HelloMBean.class, HelloMBean.NAME);
		assertEquals("1", "hello", proxy.greeting());
		
		HelloMBean proxy2 = (HelloMBean) MBeanProxy.create(HelloMBean.class, HelloMBean.NAME, "localhost", 0);
		assertEquals("2", "hello", proxy2.greeting());
		
		HelloMBean proxy3 = (HelloMBean)
			MBeanProxy.create(HelloMBean.class, HelloMBean.NAME, "localhost", _rmiAdaptorService.getPort());
		assertEquals("3", "hello", proxy3.greeting());
		
		HelloMBean proxy4 = (HelloMBean)
			MBeanProxy.create(HelloMBean.class, HelloMBean.NAME, "localhost:0");
		assertEquals("4", "hello", proxy4.greeting());
		
		HelloMBean proxy5 = (HelloMBean)
			MBeanProxy.create(HelloMBean.class, HelloMBean.NAME, "localhost:" + _rmiAdaptorService.getPort());
		assertEquals("5", "hello", proxy5.greeting());
		
		HelloMBean proxy6 = (HelloMBean)
			MBeanProxy.create(HelloMBean.class, HelloMBean.NAME, "rmi://localhost:0");
		assertEquals("6", "hello", proxy6.greeting());
	}
	

    public void testSerialize() throws Exception {
    	HelloMBean proxy = (HelloMBean) MBeanProxy.create(HelloMBean.class, HelloMBean.NAME);
        HelloMBean copy = (HelloMBean) Serializer.serialize(proxy);
        assertEquals("1", "hello", copy.greeting());
    }
    
    public void testHashCode() throws Exception {
    	HelloMBean proxy = (HelloMBean) MBeanProxy.create(HelloMBean.class, HelloMBean.NAME);
        HelloMBean copy = (HelloMBean) Serializer.serialize(proxy);
        System.out.println("hashCode:" + proxy.hashCode() + "," + copy.hashCode());
    }
    
    public void testEquals() throws Exception {
    	HelloMBean proxy = (HelloMBean) MBeanProxy.create(HelloMBean.class, HelloMBean.NAME);
        assertEquals("1", true, proxy.equals(proxy));
    }
    
    public void testTimeout() throws Exception {
    	HelloMBean proxy = (HelloMBean) MBeanProxy.create(HelloMBean.class, HelloMBean.NAME, "localhost", 0);
    	Thread.sleep(2000);
        assertEquals("1", "hello", proxy.greeting());
    }

    protected void setUp() throws Exception {
    	super.setUp();
    	JMXService.registerMBean(new Hello(), HelloMBean.NAME);
        
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(MBeanProxyTest.class);
    }

    public static void main(String[] args) {
        junit.textui.TestRunner.main(new String[]{MBeanProxyTest.class.getName()});
    }
}