package test.org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.nazuna.BooleanExpression;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.InExp;
import org.seasar.nazuna.IntegerExp;
import org.seasar.nazuna.NazunaUtil;
import org.seasar.nazuna.NullExp;

public class InExpTest extends TestCase {

    public InExpTest(String name) {
        super(name);
    }

    public void testEvaluate() throws Exception {
        IntegerExp targetExp = new IntegerExp(new Integer(2));
        List inExpList = new ArrayList();
        inExpList.add(new IntegerExp(new Integer(1)));
        inExpList.add(new IntegerExp(new Integer(2)));
        inExpList.add(new IntegerExp(new Integer(3)));
        BooleanExpression exp =
        	new InExp(targetExp, NazunaUtil.toExpressionArray(inExpList));
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate2() throws Exception {
        IntegerExp targetExp = new IntegerExp(new Integer(4));
        List inExpList = new ArrayList();
        inExpList.add(new IntegerExp(new Integer(1)));
        inExpList.add(new IntegerExp(new Integer(2)));
        inExpList.add(new IntegerExp(new Integer(3)));
        BooleanExpression exp =
        	new InExp(targetExp, NazunaUtil.toExpressionArray(inExpList));
        assertEquals("1", false, exp.evaluate(null));
    }
    
    public void testEvaluate3() throws Exception {
        IntegerExp targetExp = new IntegerExp(new Integer(2));
        List inExpList = new ArrayList();
        inExpList.add(new NullExp());
        inExpList.add(new IntegerExp(new Integer(2)));
        inExpList.add(new IntegerExp(new Integer(3)));
        BooleanExpression exp =
        	new InExp(targetExp, NazunaUtil.toExpressionArray(inExpList));
        assertEquals("1", true, exp.evaluate(null));
    }
    
    public void testEvaluate4() throws Exception {
        Expression targetExp = new NullExp();
        List inExpList = new ArrayList();
        inExpList.add(new IntegerExp(new Integer(1)));
        inExpList.add(new IntegerExp(new Integer(2)));
        inExpList.add(new IntegerExp(new Integer(3)));
        BooleanExpression exp =
        	new InExp(targetExp, NazunaUtil.toExpressionArray(inExpList));
        assertEquals("1", false, exp.evaluate(null));
    }
    
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite ( ) {
        return new TestSuite(InExpTest.class);
    }

    public static void main (String[] args) {
        junit.textui.TestRunner.main(new String[]{InExpTest.class.getName()});
    }
}