package org.seasar.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class RegExp {

	private static Map _patterns = new HashMap();
	private static Map _ignoreCasePatterns = new HashMap();
		
	private RegExp() {
	}
	
	public static final boolean match(final String regexp, final String value) {
		if (value == null) {
			return false;
		}
		Pattern pattern = (Pattern) _patterns.get(regexp);
		if (pattern == null) {
			synchronized (_patterns) {
				pattern = (Pattern) _patterns.get(regexp);
				if (pattern == null) {
					pattern = Pattern.compile(regexp);
					_patterns.put(regexp, pattern);
				}
			}
		}
		return pattern.matcher(value).matches();
	}
	
	public static final boolean matchIgnoreCase(final String regexp, final String value) {
		if (value == null) {
			return false;
		}
		Pattern pattern = (Pattern) _ignoreCasePatterns.get(regexp);
		if (pattern == null) {
			synchronized (_patterns) {
				pattern = (Pattern) _ignoreCasePatterns.get(regexp);
				if (pattern == null) {
					pattern = Pattern.compile(regexp, Pattern.CASE_INSENSITIVE);
					_ignoreCasePatterns.put(regexp, pattern);
				}
			}
		}
		return pattern.matcher(value).matches();
	}
}
