package org.seasar.util;

import java.io.File;
import java.io.FilenameFilter;

public final class JarZipFilter implements FilenameFilter {

	private static JarZipFilter _instance = new JarZipFilter();
	
	private JarZipFilter() {
	}
	
	public static final JarZipFilter getInstance() {
		return _instance;
	}
	
	public static final File[] listFiles(File dir) {
		Assertion.assertNotNull("dir", dir);
		
		File[] files = dir.listFiles(_instance);
		if (files == null) {
			files = ArrayUtil.EMPTY_FILES;
		}
		return files;
	}

	public boolean accept(File dir, String name) {
		String ext = ResourceUtil.getExtension(name);
        return "jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext);
	}

}
