package org.seasar.util;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.util.Date;

public class ArrayUtil {

    public static final Object[] EMPTY_OBJECTS = new Object[0];

    public static final Class[] EMPTY_CLASSES = new Class[0];

    public static final String[] EMPTY_STRINGS = new String[0];

    public static final BigDecimal[] EMPTY_BIGDECIMALS = new BigDecimal[0];

    public static final Date[] EMPTY_DATES = new Date[0];

    public static final URL[] EMPTY_URLS = new URL[0];

    public static final byte[] EMPTY_BYTES = new byte[0];
    
    public static final File[] EMPTY_FILES = new File[0];
    
    public static final InetAddress[] EMPTY_INETADDRESSES = new InetAddress[0];

    private ArrayUtil() {
    }

    public static Object[] add(final Object a[], final Object[] b) {
        if (a != null && b != null) {
            if (a.length != 0 && b.length != 0) {
                Object[] array = (Object[]) Array.newInstance(
                    a.getClass().getComponentType(), a.length + b.length);
                System.arraycopy(a, 0, array, 0, a.length);
                System.arraycopy(b, 0, array, a.length, b.length);
                return array;
            } else if (b.length == 0) {
                return a;
            } else {
                return b;
            }
        } else if (b == null) {
            return a;
        } else {
            return b;
        }
    }

    public static Object[] clone(final Object[] array) {
        Object[] copy = (Object[]) Array.newInstance(array.getClass().getComponentType(), array.length);
        for (int i = 0; i < array.length; i++) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static boolean equals(final Object[] a, final Object[] b) {
        if (a != null && b != null) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; i++) {
                if (a[i] != null) {
                    if (!a[i].equals(b[i])) {
                        return false;
                    }
                } else if (b[i] != null) {
                    return false;
                }
            }
            return true;
        } else if (a == null && b == null) {
            return true;
        } else {
            return false;
        }
    }
}