package org.seasar.transaction;

import java.io.Serializable;

import javax.transaction.xa.Xid;

public class XidImpl implements Xid, Serializable {

	static final long serialVersionUID = 4949943953549496531L;
    private static final int FORMAT_ID = 0x1108;
    private static final byte[] INITIAL_BRANCH_ID = convert64bytes(new byte[0]);
    private static String _base = System.currentTimeMillis() + "/";
    private static int _nextId = 0;

    private int _hashCode;
    private byte[] _globalId;
    private byte[] _branchId;

    public XidImpl() {
        _hashCode = getNextId();
        _globalId = convert64bytes((_base + Integer.toString(_hashCode)).getBytes());
        _branchId = INITIAL_BRANCH_ID;
    }

    public XidImpl(final Xid xid, final int branchId) {
        _hashCode = xid.hashCode();
        _globalId = xid.getGlobalTransactionId();
        _branchId = convert64bytes(Integer.toString(branchId).getBytes());
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])_globalId.clone();
    }

    public byte[] getBranchQualifier() {
        return (byte[])_branchId.clone();
    }

    public int getFormatId() {
        return FORMAT_ID;
    }

    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)obj;
        if (_hashCode != other._hashCode) {
            return false;
        }
        if (_globalId.length != other._globalId.length ||
                _branchId.length != other._branchId.length) {

            return false;
        }
        for (int i = 0; i < _globalId.length; i++) {
            if (_globalId[i] != other._globalId[i]) {
                return false;
            }
        }
        for (int i = 0; i < _branchId.length; i++) {
            if (_branchId[i] != other._branchId[i]) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return _hashCode;
    }

    public String toString() {
        return "[FormatId=" + FORMAT_ID +
                ", GlobalId=" + new String(_globalId).trim() +
                ", BranchId=" + new String(_branchId).trim() + "]";
    }

    private static byte[] convert64bytes(final byte[] bytes) {
        byte[] new64bytes = new byte[64];
        System.arraycopy (bytes, 0, new64bytes, 0, bytes.length);
        return new64bytes;
    }

    private static synchronized int getNextId() {
        return _nextId++;
    }
}