package org.seasar.system;

import org.seasar.util.SeasarException;

public final class RMIAdaptorImpl implements RMIAdaptor {
	
	public RMIAdaptorImpl() {
	}
	
	public Object invoke(final String name, final String operationName,
            final Object[] parameters, final String[] signatures) throws Exception {

		return JMXService.invoke(name, operationName, parameters, signatures);
    }
    
    public String addNotificationListener(String targetName,
    		RMINotificationListener rmiNotificationListener) throws SeasarException {
    			
    	RMINotificationListenerServerAdaptor serverAdaptor =
    		new RMINotificationListenerServerAdaptor(targetName, rmiNotificationListener);
    	serverAdaptor.addNotificationListener();
    	return serverAdaptor.getListenerName();
    }
    
    public void removeNotificationListener(String listenerName) throws SeasarException {
    	RMINotificationListenerServerAdaptor serverAdaptor =
    		(RMINotificationListenerServerAdaptor) JMXService.getMBean(listenerName);
    	if (serverAdaptor != null) {
    		serverAdaptor.removeNotificationListener();
    	}
    }

}