package org.seasar.nazuna.amf;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

import org.seasar.nazuna.ArgType;
import org.seasar.nazuna.Flowlet;
import org.seasar.nazuna.FlowletContainer;
import org.seasar.nazuna.InputType;
import org.seasar.nazuna.Nazuna;
import org.seasar.nazuna.NzRecordSet;
import org.seasar.nazuna.RuletContainer;
import org.seasar.nazuna.RuletFacade;
import org.seasar.nazuna.Sqlet;
import org.seasar.nazuna.SqletContainer;
import org.seasar.util.Assertion;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class NazunaInvoker {

	private NazunaInvoker() {
	}

	public static final Object executeRulet(String name, Object[] args)
			throws SeasarException {
				
		Assertion.assertNotNull("args", args);
		
		RuletFacade facade = RuletContainer.getRuletFacade(name);
		Method doExecuteMethod = facade.getDoExecuteMethod();
		Class[] parameterTypes = doExecuteMethod.getParameterTypes();
		for (int i = 0; i < args.length; ++i) {
			args[i] = AMFUtil.adjustValue(args[i], parameterTypes[i]);
		}
		return Nazuna.executeRulet(name, args);
	}
	
	public static final Object execute(String name, Object[] args)
			throws SeasarException {
				
		Assertion.assertNotNull("args", args);
		
		Flowlet flowlet = FlowletContainer.getFlowlet(name);
		InputType inputType = flowlet.getInputType();
		if (inputType == null) {
			return Nazuna.execute(name);
		}
		return Nazuna.execute(name, convertArgsToMap(args, inputType));
	}
	
	public static final List executeQuery(String name, Object[] args)
			throws SeasarException {
				
		Assertion.assertNotNull("args", args);
		
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return Nazuna.executeQuery(name);
		}
		return Nazuna.executeQuery(name, convertArgsToMap(args, inputType));
	}
	
	public static final NzRecordSet executeRSQuery(String name, Object[] args)
			throws SeasarException {
			
		Assertion.assertNotNull("args", args);
	
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return Nazuna.executeRSQuery(name);
		}
		return Nazuna.executeRSQuery(name, convertArgsToMap(args, inputType));
	}
	
	public static final int executeUpdate(String name, Object[] args)
			throws SeasarException {
				
		Assertion.assertNotNull("args", args);
		
		Sqlet sqlet = SqletContainer.getSqlet(name);
		InputType inputType = sqlet.getInputType();
		if (inputType == null) {
			return Nazuna.executeUpdate(name);
		}
		return Nazuna.executeUpdate(name, convertArgsToMap(args, inputType));
	}
	
	private static Map convertArgsToMap(Object[] args, InputType inputType) {
		Map argMap = new SMap();
		for (int i = 0; i < inputType.getArgTypeSize(); ++i) {
			ArgType argType = inputType.getArgType(i);
			Object value = AMFUtil.adjustValue(args[i], argType.getArgClass());
			argMap.put(argType.getName(), value);
		}
		return argMap;
	}
}
