package org.seasar.nazuna;

import java.util.Map;

import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public final class SqletContainer {

	private static Map _sqletDeployers = new SMap(89);
	
	private SqletContainer() {
	}

	public static Sqlet getSqlet(String name) throws SeasarException {
		SqletDeployer deployer = getSqletDeployer(name);
		deployer.deploy();
		return deployer.getSqlet();
    }
    
    public static SqletDeployer getSqletDeployer(String name)
    		throws SeasarException {
    			
		name = name.intern();
        SqletDeployer deployer = (SqletDeployer) _sqletDeployers.get(name);
        if (deployer != null) {
        	return deployer;
        }
        synchronized (_sqletDeployers) {
        	deployer = (SqletDeployer) _sqletDeployers.get(name);
            if (deployer == null) {
                deployer = new SqletDeployer(name);
                _sqletDeployers.put(name, deployer);
            }    
        }
        return deployer;
    }
}
