package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class SetVariableExp extends AbstractVariableExp {

	private Expression _exp;
	
    public SetVariableExp(final String name, final Expression exp) {
        super(name);
        Assertion.assertNotNull("exp", exp);
        
        _exp = exp;
    }

    public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
    	Object value = _exp.evaluateValue(ruleContext);
    	if (_names.length == 1) {
    		ruleContext.setVarValue(_names[0], value);
    	} else {
	    	Object target = ruleContext.getValue(_names[0]);
	    	for (int i = 1; i < _names.length - 1; ++i) {
	    		target = NazunaUtil.getProperty(target, _names[i]);
	    	}
	    	NazunaUtil.setProperty(target, _names[_names.length - 1], value);
    	}
    	return value;
    }
}
