package org.seasar.nazuna;

import java.lang.reflect.Array;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class SetArrayVariableExp implements Expression {

	private String _name;
	private int _index;
	private Expression _argExp;
	
    public SetArrayVariableExp(final String name, final int index,
    		final Expression argExp) {
    		
    	Assertion.assertNotNull("name", name);
    	Assertion.assertTrue(index >= 0, "ESSR0004", "index");
    	Assertion.assertNotNull("argExp", argExp);
    		
        _name = name;
        _index = index;
        _argExp = argExp;
    }

    public Object evaluateValue(final RuleContext ruleContext) throws SeasarException {
    	Object arg = _argExp.evaluateValue(ruleContext);
    	Object array = ruleContext.getValue(_name);
    	Array.set(array, _index, arg);
    	return arg;
    }
}
