package org.seasar.nazuna;

import org.seasar.util.Assertion;
import org.seasar.util.SeasarException;

public final class NotBetweenExp implements BooleanExpression {

    private final Expression _arg1Exp;
    private final Expression _fromExp;
    private final Expression _toExp;

    public NotBetweenExp(Expression arg1Exp, Expression fromExp, Expression toExp) {
    	Assertion.assertNotNull("arg1Exp", arg1Exp);
    	Assertion.assertNotNull("fromExp", fromExp);
    	Assertion.assertNotNull("toExp", toExp);
    	
        _arg1Exp = arg1Exp;
        _fromExp = fromExp;
        _toExp = toExp;
    }


    public boolean evaluate(RuleContext ruleContext) throws SeasarException {
        Comparable arg1 = (Comparable) _arg1Exp.evaluateValue(ruleContext);
        Comparable from = (Comparable) _fromExp.evaluateValue(ruleContext);
        Comparable to = (Comparable) _toExp.evaluateValue(ruleContext);
        if (arg1 == null || from == null || to == null) {
            return false;
        } else {
            return arg1.compareTo(from) < 0 || arg1.compareTo(to) > 0;
        }
    }
}