package org.seasar.nazuna;

import java.util.ArrayList;
import java.util.List;

import org.seasar.util.SeasarException;

public final class CaseTag extends AbstractRuleStatement implements WhenTagAware, ElseTagAware {

	private List _whenTags = new ArrayList();
	private ElseTag _elseTag;
	
	public CaseTag(Object parent, String location) {
		super(parent, location);
	}
	
	public void execute(RuleContext ruleContext) throws SeasarException {
		try {
			for (int i = 0; i < _whenTags.size(); ++i) {
				WhenTag whenTag = (WhenTag) _whenTags.get(i);
				whenTag.execute(ruleContext);
				if (ruleContext.isWhenBreaked()) {
					ruleContext.clearWhenBreaked();
					return;
				}
				if (ruleContext.isReturned() || ruleContext.isThrowed()) {
					return;
				}
			}
			if (_elseTag != null) {
				_elseTag.execute(ruleContext);
			}
		} catch (Throwable t) {
			ruleContext.setThrowable(t, getLocation());
		}
	}

	public void addWhenTag(WhenTag whenTag) {
		_whenTags.add(whenTag);
	}

	public void setElseTag(ElseTag elseTag) {
		_elseTag = elseTag;
	}
}
