/*
class seasar.unit.TestResult

public:
Number testCount
Number successCount
Number failureCount
void addFailure(seasar.unit.TestFailure failure)
Number getFailure(Number index)
void addSuccess()

private:
Array failures
Number getFailureCount()
*/
if (seasar.unit.TestResult === undefined) {
	#include "seasar/lang/SObject.as"
	
	seasar.lang.SObject.defineClass("seasar.unit.TestResult", null,
		["failures", "testCount", "successCount"],
		function() {
			this.failures = new Array();
			this.testCount = 0;
			this.successCount = 0;
		});
	
	var proto = seasar.unit.TestResult.prototype;
	
	proto.addFailure = function(failure) {
		this.testCount++;
		this.failures.push(failure);
	}
	
	proto.getFailure = function(index) {
		return this.failures[index];
	}
	
	proto.getFailureCount = function() {
		return this.failures.length;
	}
	
	proto.addProperty("failureCount", proto.getFailureCount, null);
	
	proto.addSuccess = function() {
		this.testCount++;
		this.successCount++;
	}
	
	proto.toString = function() {
		var str = "";
		if (this.failures.length == 0) {
			str = "Success(total=" + this.testCount + ")\n";
		} else {
			var num = this.failureCount;
			str = "Failure(total=" + this.testCount + ", fail=" + num + ")\n";
			for (var i = 0; i < num; ++i) {
				str += this.failures[i].toString() + "\n";
			}
		}
		return str;
	}
	
	delete proto;
}