/**************************************************************************
 Moenizer - Allow to set background image for OmegaT.
 
 Copyright (C) 2014 Yu Tang
               Home page: http://sourceforge.jp/users/yu-tang/
               Support center: http://sourceforge.jp/users/yu-tang/pf/Moenizer/

 This file is part of plugin for OmegaT.
 http://www.omegat.org/

 License: GNU GPL version 3 or (at your option) any later version.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import groovy.util.ConfigObject;
import java.util.List;
import java.util.Map;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.Effect;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.IEffect;
import org.omegat.util.Log;

/**
 *
 * @author Yu-Tang
 */
public class ThemeChanger {
    
    private MoeUI model = null;
    private ConfigObject theme = null;

    public ThemeChanger(MoeUI ui) {
        this.model = ui;
    }

    public void setTheme(ConfigObject theme) {
        this.theme = theme;

        // check constraints
        //@@TODO 整合性チェック。たとえば、mainWindow 対象の処理が複数ある、など
        //@@TODO MainWindow の透過除外パーツに、後続指定のペインを含める
    }

    public void apply() {
        // no theme, no effects
        if (theme == null || !theme.containsKey("effects")) { //@@TODO literal to const
            return;
        }

        // get effect list (ArrayList)
        List<ConfigObject> effects = (List<ConfigObject>) theme.get("effects"); //@@TODO literal to const
        if (effects.isEmpty()) {
            return;
        }

        // apply effects
        for (Map conf: effects) {
            
            try {
                Effect.Type type = (Effect.Type) conf.get("type");
                IEffect effect = Effect.create(type, conf);
                effect.invoke(model);
            } catch (Exception ex) {
                ex.printStackTrace();
                Log.log("Error on ThemeChanger#apply(): " + ex.getMessage());
            }
        }
    }
}
