/*
 *  Copyright (C) 2012 Altera Corporation <www.altera.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

MEMORY { .sdram : ORIGIN = (0), LENGTH = (0xffffffff) }

OUTPUT_FORMAT("elf32-littlearm", "elf32-littlearm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)
SECTIONS
{
	. = 0x00000000;

	. = ALIGN(4);
	.text	:
	{
		arch/arm/cpu/armv7/start.o	(.text*)
		*(.text*)
	} >.sdram

	. = ALIGN(4);
	.rodata : { *(SORT_BY_ALIGNMENT(SORT_BY_NAME(.rodata*))) } >.sdram

	. = ALIGN(4);
	.data : { *(SORT_BY_ALIGNMENT(.data*)) } >.sdram

	. = ALIGN(4);
	__image_copy_end = .;

	.end :
	{
		*(.__end)
	}

	.bss : {
		. = ALIGN(4);
		__bss_start = .;
		*(.bss*)
		. = ALIGN(4);
		__bss_end = .;
	} >.sdram

	. = ALIGN(8);
	__malloc_start = .;
	. = . + CONFIG_SPL_MALLOC_SIZE;
	__malloc_end = .;

	. = . + CONFIG_SPL_STACK_SIZE;
	. = ALIGN(8);
	__stack_start = .;
}
