//! @file scene.cpp
//! @brief eʂǗNX̒`

//--------------------------------------------------------------------------------
// 
// OpenXOPS
// Copyright (c) 2014-2015, OpenXOPS Project / [-_-;](mikan) All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, 
//   this list of conditions and the following disclaimer in the documentation 
//   and/or other materials provided with the distribution.
// * Neither the name of the OpenXOPS Project nor the@names of its contributors 
//   may be used to endorse or promote products derived from this software 
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL OpenXOPS Project BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//--------------------------------------------------------------------------------

#include "scene.h"

//! RXgN^
scene::scene()
{
	d3dg = NULL;
	inputCtrl = NULL;
	framecnt = 0;
}

//! fBXgN^
scene::~scene()
{}

//! NXݒ
void scene::SetClass(StateMachine *in_GameState, D3DGraphics *in_d3dg, InputControl *in_inputCtrl)
{
	GameState = in_GameState;
	d3dg = in_d3dg;
	inputCtrl = in_inputCtrl;
}

//! V[쐬
int scene::Create()
{
	inputCtrl->MoveMouseCenter();
	framecnt = 0;

	GameState->NextState();
	return 0;
}

//! V[͏
void scene::Input()
{
	inputCtrl->GetInputState(false);

	if( inputCtrl->CheckKeyDown(GetEscKeycode()) ){
		GameState->PushBackSpaceKey();
	}

	if( inputCtrl->CheckMouseButtonUpL() ){
		GameState->PushMouseButton();
	}
}

//! V[vZ
void scene::Process()
{
	framecnt += 1;
}

//! V[`揈
void scene::RenderMain()
{
	if( d3dg->StartRender() ){ return; }

	d3dg->Draw2DBox(0, 0, SCREEN_WIDTH, SCREEN_HEIGTH, D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,1.0f));
	d3dg->Draw2DTextureFontText(10, 10, "hello world !", D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,1.0f), 20, 32);

	d3dg->ScreenBrightness(SCREEN_WIDTH, SCREEN_HEIGTH, GameConfig.GetBrightness());

	d3dg->EndRender();
}

//! V[
void scene::Destroy()
{
	GameState->NextState();
}

//! RXgN^
D2Dscene::D2Dscene()
{}

//! fBXgN^
D2Dscene::~D2Dscene()
{}

//! 2DV[
int D2Dscene::Create()
{
	gametitle = d3dg->LoadTexture("data\\title.dds", false, false);
	GameState->NextState();
	if( gametitle == -1 ){ return 1; }
	return 0;
}

//! 2DV[`揈i2Dj
void D2Dscene::Render2D()
{
	d3dg->Draw2DTextureFontText(10, 10, "hello world !", D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,1.0f), 20, 32);
}

//! 2DV[`揈iCj
void D2Dscene::RenderMain()
{
	if( d3dg->StartRender() ){ return; }

	d3dg->Draw2DTexture(0, 0, gametitle, SCREEN_WIDTH, SCREEN_HEIGTH, 1.0f);
	d3dg->Draw2DBox(11, 11, SCREEN_WIDTH - 10, SCREEN_HEIGTH - 10, D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,0.9f));

	Render2D();

	d3dg->ScreenBrightness(SCREEN_WIDTH, SCREEN_HEIGTH, GameConfig.GetBrightness());

	d3dg->EndRender();
}

//! 2DV[
void D2Dscene::Destroy()
{
	d3dg->CleanupTexture(gametitle);
	GameState->NextState();
}


//! RXgN^
D3Dscene::D3Dscene()
{}

//! fBXgN^
D3Dscene::~D3Dscene()
{}

//! 3DV[NXݒ
void D3Dscene::SetClass(StateMachine *in_GameState, D3DGraphics *in_d3dg, InputControl *in_inputCtrl, SoundManager *in_GameSound)
{
	GameState = in_GameState;
	d3dg = in_d3dg;
	inputCtrl = in_inputCtrl;
	GameSound = in_GameSound;
}

//! 3DV[vZ
void D3Dscene::Process()
{
	GameSound->PlayWorldSound(camera_x, camera_y, camera_z, camera_rx);
}

//! 3DV[TEhĐ
void D3Dscene::Sound()
{
	//TEhĐ
	GameSound->PlayWorldSound(camera_x, camera_y, camera_z, camera_rx);
}

//! 3DV[`揈i3Dj
void D3Dscene::Render3D()
{}

//! 3DV[`揈i2Dj
void D3Dscene::Render2D()
{}

//! 3DV[`揈iCj
void D3Dscene::RenderMain()
{
	if( d3dg->StartRender() ){ return; }

	Render3D();
	Render2D();

	d3dg->ScreenBrightness(SCREEN_WIDTH, SCREEN_HEIGTH, GameConfig.GetBrightness());

	d3dg->EndRender();
}